/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.axis;

import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

import com.ibm.trl.tcg.pts.integrity.IntegrityReport;
import com.ibm.trl.tcg.pts.integrity.ReferenceManifest;
import com.ibm.trl.tcg.pts.integrity.VerificationResult;
import com.ibm.trl.tcg.pts.tools.Base64Tool;

public class JwsWrapper {

	private String endpoint = "http://localhost:8080/axis/Server.jws";
	private Service service;
	private Call call;

	public void open(String hostname) throws Exception {
		
		try {
			endpoint = "http://" + hostname + ":8080/axis/Server.jws";
			//endpoint = "https://" + hostname + "/axis/Server.jws";
			
			System.out.println("open : " + endpoint);

			
			service = new Service();
			// Session
			service.setMaintainSession(true);


			call = (Call) service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(endpoint));

		
		} catch (ExceptionInInitializerError e1) {
			System.err.println("In GCJ env, this error happen....");
			e1.getCause().printStackTrace();
			throw new Exception("open failed, ExceptionInInitializerError ");
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new Exception("open failed");
		}

	}
	
	/**
	 * 
	 * open with SSL(443) 
	 * 
	 * @param hostname
	 * @throws Exception
	 */
	public void sopen(String hostname, String keystore, String password) throws Exception {
		
		System.out.println("SM DEBUG ");
		System.out.println(" hostname " + hostname);
		//System.out.println(" keystore " + keystore);
		//System.out.println(" password " + password);
		
		/// 07/12/14 move to COnfig.java to handle JRE and GCJ
		//System.setProperty("javax.net.ssl.trustStore" , keystore );
		//System.setProperty("javax.net.ssl.trustStorePassword",password);
		
		//endpoint = "http://" + hostname + ":8080/axis/Server.jws";
		endpoint = "https://" + hostname + "/axis/Server.jws";
		
		service = new Service();
		// Session
		service.setMaintainSession(true);
		
		call = (Call) service.createCall();
		call.setTargetEndpointAddress(new java.net.URL(endpoint));
	}

	public void close() {
		
		
		// TODO Auto-generated method stub
		
	}

	public byte[] hello(String username) throws Exception {
		//username="TestX60";
		call.setOperationName("hello010");
		call.addParameter("username", XMLType.XSD_STRING, ParameterMode.IN);
		call.setReturnType(XMLType.XSD_STRING);

		String base64nonce = (String) call.invoke(
				new Object[] { username });
		call.removeAllParameters();

		//Base64Tool.decodeToFile(base64vr, vrFilename);

		System.out.println("nonce : " + base64nonce);
		byte[] nonce = Base64Tool.decode(base64nonce);
		return nonce;
	}

	public VerificationResult validate(
			IntegrityReport localIR, 
			ReferenceManifest biosRM, 
			ReferenceManifest runtimeRM, 
			String option) throws Exception {
		
		System.out.println("Call PTS Server" );
		
		/* IR & RMs to Base64 */
		String base64IR = localIR.getBase64String();
		String base64BiosRM = biosRM.getBase64String();
		String base64RuntimeRM = runtimeRM.getBase64String();
		
		// TODO not work
		//String base64IR = localIR.getGipedBase64String();
		//String base64BiosRM = biosRM.getGipedBase64String();
		//String base64RuntimeRM = runtimeRM.getGipedBase64String();
		
		System.out.println("IR  size : " + base64IR.length());
		System.out.println("RM0 size : " + base64BiosRM.length());
		System.out.println("RM1 size : " + base64RuntimeRM.length());
		
		/* Call */
		call.setOperationName("validate010");
		call.addParameter("base64IR", XMLType.XSD_STRING, ParameterMode.IN);
		call.addParameter("base64BiosRM", XMLType.XSD_STRING, ParameterMode.IN);
		call.addParameter("base64RuntimeRM", XMLType.XSD_STRING, ParameterMode.IN);
		call.addParameter("option", XMLType.XSD_STRING, ParameterMode.IN);
		call.setReturnType(XMLType.XSD_STRING);

		String base64VR = (String) call.invoke(
				new Object[] { base64IR, base64BiosRM, base64RuntimeRM, option });
		call.removeAllParameters();

		VerificationResult vr = new VerificationResult();
		vr.parseBase64String(base64VR);
		
		
		//Base64Tool.decodeToFile(base64vr, vrFilename);

		//	System.out.println("Got result : " + new String(Base64Tool.decode(base64vr)));

		//} catch (Exception e) {
		//	// TODO Auto-generated catch block
		//	e.printStackTrace();
		//}

		
		return vr;
	}



}
