/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swing;

import java.awt.Color;
import java.awt.Graphics;

import javax.swing.JPanel;

import net.sf.jtreemap.swing.ColorProvider;
import net.sf.jtreemap.swing.JTreeMap;
import net.sf.jtreemap.swing.Value;


public class IntegrityColorProvider extends ColorProvider {

	private JTreeMap jTreeMap;
	private JPanel legend;

	public IntegrityColorProvider(final JTreeMap jTreeMap) {
        this.jTreeMap = jTreeMap;
    }
	
	@Override
	public Color getColor(Value value) {	
		double v = value.getValue();
		
		if (v == 0.0) return new Color(0,255,0); // VALID - Green
		else if (v == 1.0) return new Color(255,0,0); // INVALID - Red
		else if (v == 2.0) return new Color(127,127,127); // UNVERIFIED - Gray
		else return new Color(0,0,0); // ERROR - BLACK
	}

	@Override
	public JPanel getLegendPanel() {
        if (this.legend == null) {
            this.legend = new Legend();
        }
        return this.legend;
	}

	private class Legend extends JPanel {
	       public Legend() {
	            this.setPreferredSize(new java.awt.Dimension(
	                    100, 100));
	        }

	        @Override
	        public void paintComponent(final Graphics g) {
	            super.paintComponent(g);

	            g.setColor(Color.black);


	            g.setColor(Color.black);
	            g.drawString("Hoge",10,10);
	        }
	}
}
