/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.vulnerability.deb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

import javax.swing.text.html.parser.ParserDelegator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibm.trl.tcg.pts.ibatis.SqlConfigVul;
import com.ibm.trl.tcg.pts.ibatis.dto.Debians;
import com.ibm.trl.tcg.pts.vulnerability.tool.GetFileFromInternet;

/**
 * Insert detailed info of Debian Security Advisory by url stored in
 * vulnerability database.
 * 
 * @author Megumi Nakamura
 */
public class GetInsertDebianDetailInfo {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	public GetInsertDebianDetailInfo() {
	}

	/**
	 * Download DSA file and Update vuldb.
	 */
	public void updateVuldb(){
		updateVuldb(null);
	}
	
	/**
	 * Download DSA file and Update vuldb.
	 * @param tmpDir Directory for output files
	 */
	public void updateVuldb(String tmpDir) {
		try {
			SqlMapClient sqlMapVul = SqlConfigVul.getSqlMapInstance();
			List<Debians> list = (List<Debians>) sqlMapVul
					.queryForList("getDebianAll");

			Reader reader = null;

			for (Debians d : list) {
				String url = d.getDebianUrl();
				if (url != null) {
					String filename = url + ".en.html";
					String file = new GetFileFromInternet().getFile(filename,
							tmpDir, false); // "sandbox/dsa");
					reader = new BufferedReader(new FileReader(file));
					new ParserDelegator().parse(reader, new DebianInfoParser(),
							true);
					reader.close();
				}
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SQLException ex) {
			do {
				log.error("SQLSTATE: " + ex.getSQLState());
				log.error("ERR-CODE: " + ex.getErrorCode());
				log.error("ERR-MSEG: " + ex.getMessage());
				ex = ex.getNextException();
			} while (null != ex);
		}
	}
	
	
	/**
	 * @param args --outdir
	 */
	public static void main (String[] args) {
		String tmpDirname = null;
		
		for (int i = 0; i < args.length; ++i) {
			if ("--outdir".equals(args[i])) {
				tmpDirname = args[++i];
			} else {
				System.err.println("Unknown option " + args[i]);
				usage();
				return;
			}
		}
		
		new GetInsertDebianDetailInfo().updateVuldb(tmpDirname);
	}
	
	/**
	 * Usage.
	 */
	private static void usage() {
		System.out.println("Usage: dsadetail [OPTIONS]");
		System.out.println(" OPTIONS");
		System.out.println(" --outdir /tmp (optional: the directory to store the html files.)");
	}

}
