/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.xacml;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLReader;

import com.ibm.trl.tcg.pts.integrity.SaxErrorHandler;
import com.ibm.trl.tcg.pts.tools.XmlTool;

/**
 * 
 * @author Seiji Munetoh
 * 
 */
public class XacmlRequest {
	/* Logger */
	Log log = LogFactory.getLog(this.getClass());

	private String _namespace = "urn:oasis:names:tc:xacml:1.0:context";

	// private String _namespace =
	// "urn:oasis:names:tc:xacml:2.0:context:schema:cd:04";
	private Document _doc;

	private Element _req;

	private String _filename;

	private boolean _indent = true;

	// private boolean _verbose = false;

	// private String _schemasPath = "../../pvs/xacml/schemas/";
	private String _schemasPath = "../schemas/";

	private String[] _schemas = {
			_schemasPath + "cs-xacml-schema-context-01.xsd",
			_schemasPath + "cs-xacml-schema-policy-01.xsd" };

	// private String[] _schemas = {
	// _schemasPath + "access_control-xacml-2.0-context-schema-cd-04.xsd",
	// _schemasPath + "access_control-xacml-2.0-policy-schema-cd-04.xsd"
	// };
	// _schemasPath + "xmldsig-core-schema.xsd" };
	private Element _subject;

	public XacmlRequest() {
		// init();
	}

	public XacmlRequest(String filename) {
		load(filename);
	}

	/**
	 * Create new Request
	 */
	public void init() {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			DOMImplementation domImpl = builder.getDOMImplementation();
			_doc = domImpl.createDocument(_namespace, "Request", null);

			_req = _doc.getDocumentElement();
			_req.setAttribute("xmlns:xsi",
					"http://www.w3.org/2001/XMLSchema-instance");

			_subject = _doc.createElement("Subject");
			_req.appendChild(_subject);

			/* Resource TNC */
			Element res = _doc.createElement("Resource");
			Element ra = _doc.createElement("Attribute");
			Element rav = _doc.createElement("AttributeValue");

			ra.setAttribute("AttributeId",
					"urn:oasis:names:tc:xacml:1.0:resource:resource-id");
			ra.setAttribute("DataType",
					"http://www.w3.org/2001/XMLSchema#string");
			rav.appendChild(_doc.createTextNode("intranet"));
			ra.appendChild(rav);
			res.appendChild(ra);
			_req.appendChild(res);

			/* Action TNC */
			Element act = _doc.createElement("Action");
			Element aa = _doc.createElement("Attribute");
			Element aav = _doc.createElement("AttributeValue");

			aa.setAttribute("AttributeId",
					"urn:oasis:names:tc:xacml:1.0:action:action-id");
			aa.setAttribute("DataType",
					"http://www.w3.org/2001/XMLSchema#string");
			aav.appendChild(_doc.createTextNode("connect"));
			aa.appendChild(aav);
			act.appendChild(aa);
			_req.appendChild(act);

		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 
	 * 
	 * @param rimmFilename
	 */
	public void load(String filename) {
		_filename = filename;
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			_doc = builder.parse(new File(_filename));

			_req = _doc.getDocumentElement();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @param rimmFilename
	 * @throws Exception
	 */
	public void save(String filename) throws Exception {
		_filename = filename;
		XmlTool.saveToFile(filename, _doc, _indent);

		if (log.isDebugEnabled())
			log.debug("toFile done");
	}

	/**
	 * validate RM file
	 * 
	 * @return
	 * @throws Exception
	 */
	public boolean validate() throws Exception {
		if (_filename == null) {
			// TODO supports internal DOM
			throw new Exception(
					"Sorry, only work for given RM file - TODO item");
		}

		SAXParserFactory f = SAXParserFactory.newInstance();
		f.setNamespaceAware(true);
		f.setValidating(true);

		SAXParser p = f.newSAXParser();
		p.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage",
				"http://www.w3.org/2001/XMLSchema");
		p.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource",
				_schemas);

		XMLReader reader = p.getXMLReader();
		SaxErrorHandler eh = new SaxErrorHandler();
		reader.setErrorHandler(eh);

		reader.setFeature("http://xml.org/sax/features/validation", true);
		reader.setFeature("http://apache.org/xml/features/validation/schema",
				true);
		reader.setFeature("http://xml.org/sax/features/namespaces", true);

		/* Validate RIMM */
		reader.parse(_filename);

		if (eh.rc == false) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * 
	 * DataType http://www.w3.org/2001/XMLSchema#boolean
	 * urn:oasis:names:tc:xacml:1.0:data-type:x500Name
	 * 
	 * @param name
	 * @param value
	 * @param dataType
	 */
	public void addAttribute(String name, String value, String dataType) {
		Element att = _doc.createElement("Attribute");
		Element attv = _doc.createElement("AttributeValue");

		att.setAttribute("AttributeId", name);
		att.setAttribute("DataType", dataType);
		attv.appendChild(_doc.createTextNode(value));
		att.appendChild(attv);
		_subject.appendChild(att);

		// TODO Auto-generated method stub

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	public void setSchemaPath(String path) {

		_schemasPath = path;
		_schemas[0] = _schemasPath + "/cs-xacml-schema-context-01.xsd";
		_schemas[1] = _schemasPath + "/cs-xacml-schema-policy-01.xsd";
		// TODO

	}

}
