/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection m_conn;
    OracleResultSetImpl m_rset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_update;
    private int m_beginColumnIndex;
    private int m_columnCount;
    private int m_wasNull;
    OracleResultSetCache m_cache;
    int m_currentRow;
    private int m_numRowsCached;
    private boolean m_allRowsCached;
    private int m_lastRefetchSz;
    private Vector m_refetchRowids;
    private OraclePreparedStatement m_refetchStmt;
    private int m_usrFetchDirection;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n, int n2) throws SQLException {
        this.m_conn = (PhysicalConnection)scrollRsetStatement.getConnection();
        this.m_rset = oracleResultSetImpl;
        this.m_metadata = null;
        this.m_scrollStmt = scrollRsetStatement;
        this.m_type = n;
        this.m_update = n2;
        this.m_autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.m_beginColumnIndex = ScrollableResultSet.needIdentifier(n, n2) ? 1 : 0;
        this.m_columnCount = 0;
        this.m_wasNull = -1;
        this.m_cache = scrollRsetStatement.getResultSetCache();
        if (this.m_cache == null) {
            this.m_cache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.m_cache.clear();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
        this.m_currentRow = 0;
        this.m_numRowsCached = 0;
        this.m_allRowsCached = false;
        this.m_lastRefetchSz = 0;
        this.m_refetchRowids = null;
        this.m_refetchStmt = null;
        this.m_usrFetchDirection = 1000;
    }

    public synchronized void close() throws SQLException {
        if (this.m_rset != null) {
            this.m_rset.close();
        }
        if (this.m_refetchStmt != null) {
            this.m_refetchStmt.close();
        }
        if (this.m_scrollStmt != null) {
            this.m_scrollStmt.notify_close_rset();
        }
        if (this.m_refetchRowids != null) {
            this.m_refetchRowids.removeAllElements();
        }
        this.m_rset = null;
        this.m_scrollStmt = null;
        this.m_refetchStmt = null;
        this.m_refetchRowids = null;
        this.m_metadata = null;
        this.m_conn = null;
        try {
            if (this.m_cache != null) {
                this.m_cache.clear();
                this.m_cache.close();
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        this.m_cache = null;
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.m_wasNull == -1) {
            DatabaseError.throwSqlException(24);
        }
        return this.m_wasNull == 1;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.m_scrollStmt);
    }

    synchronized void resetBeginColumnIndex() {
        this.m_beginColumnIndex = 0;
    }

    synchronized ResultSet getResultSet() {
        return this.m_rset;
    }

    synchronized int removeRowInCache(int n) throws SQLException {
        if (!this.isEmptyResultSet() && this.isValidRow(n)) {
            this.removeCachedRowAt(n);
            --this.m_numRowsCached;
            if (n >= this.m_currentRow) {
                --this.m_currentRow;
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int refreshRowsInCache(int n, int n2, int n3) throws SQLException {
        OracleResultSet oracleResultSet = null;
        int n4 = 0;
        n4 = this.get_refetch_size(n, n2, n3);
        try {
            if (n4 > 0) {
                if (n4 != this.m_lastRefetchSz) {
                    if (this.m_refetchStmt != null) {
                        this.m_refetchStmt.close();
                    }
                    this.m_refetchStmt = this.prepare_refetch_statement(n4);
                    this.m_lastRefetchSz = n4;
                }
                this.prepare_refetch_binds(this.m_refetchStmt, n4);
                oracleResultSet = (OracleResultSet)this.m_refetchStmt.executeQuery();
                this.save_refetch_results(oracleResultSet, n, n4, n3);
            }
        }
        finally {
            if (oracleResultSet != null) {
                oracleResultSet.close();
            }
        }
        return n4;
    }

    public synchronized boolean next() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.m_currentRow < 1 ? 1 : ++this.m_currentRow;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.m_currentRow < 1;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.m_currentRow > 0 && !this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.m_currentRow == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        return !this.isEmptyResultSet() && this.isValidRow(this.m_currentRow) && !this.isValidRow(this.m_currentRow + 1);
    }

    public synchronized void beforeFirst() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.m_currentRow = 0;
        }
    }

    public synchronized void afterLast() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.m_currentRow = this.getLastRow() + 1;
        }
    }

    public synchronized boolean first() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = 1;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean last() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.getLastRow();
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized int getRow() throws SQLException {
        if (this.isValidRow(this.m_currentRow)) {
            return this.m_currentRow;
        }
        return 0;
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (n == 0) {
            DatabaseError.throwSqlException(68, "absolute (0)");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (n > 0) {
            this.m_currentRow = n;
        } else if (n < 0) {
            this.m_currentRow = this.getLastRow() + 1 + n;
        }
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (this.isValidRow(this.m_currentRow)) {
            this.m_currentRow += n;
            return this.isValidRow(this.m_currentRow);
        }
        DatabaseError.throwSqlException(82, "relative");
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.isAfterLast() ? this.getLastRow() : --this.m_currentRow;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        Datum datum;
        this.m_wasNull = -1;
        if (!this.isValidRow(this.m_currentRow)) {
            DatabaseError.throwSqlException(11);
        }
        if (n < 1 || n > this.getColumnCount()) {
            DatabaseError.throwSqlException(3);
        }
        this.m_wasNull = (datum = this.getCachedDatumValueAt(this.m_currentRow, n + this.m_beginColumnIndex)) == null ? 1 : 0;
        return datum;
    }

    public synchronized String getString(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.stringValue();
        }
        return null;
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized short getShort(int n) throws SQLException {
        long l = this.getLong(n);
        if (l > 65537L || l < -65538L) {
            DatabaseError.check_error(26, "getShort");
        }
        return (short)l;
    }

    public synchronized int getInt(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.intValue();
        }
        return 0;
    }

    public synchronized long getLong(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.longValue();
        }
        return 0L;
    }

    public synchronized float getFloat(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized double getDouble(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DatabaseError.check_error(4, "getBytes");
        }
        return null;
    }

    public synchronized Date getDate(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Time getTime(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            DBConversion dBConversion = this.m_conn.conversion;
            byte[] byArray = datum.shareBytes();
            if (datum instanceof RAW) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            if (datum instanceof CHAR) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            DatabaseError.check_error(4, "getUnicodeStream");
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.getObject(n, this.m_conn.getTypeMap());
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n);
        return dATE != null ? dATE.dateValue(calendar) : null;
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n);
        return dATE != null ? dATE.timeValue(calendar) : null;
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n);
        return dATE != null ? dATE.timestampValue(calendar) : null;
    }

    public synchronized URL getURL(int n) throws SQLException {
        URL uRL = null;
        int n2 = this.getInternalMetadata().getColumnType(n);
        int n3 = SQLUtil.get_internal_type(n2);
        if (n3 == 96 || n3 == 1 || n3 == 8) {
            try {
                uRL = new URL(this.getString(n));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(136);
            }
        } else {
            throw new SQLException("Conversion to java.net.URL not supported.");
        }
        return uRL;
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        DatabaseError.check_error(4, "getCursor");
        return null;
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DatabaseError.check_error(4, "getROWID");
        }
        return null;
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DatabaseError.check_error(4, "getNUMBER");
        }
        return null;
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DatabaseError.check_error(4, "getDATE");
        }
        return null;
    }

    public synchronized TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof TIMESTAMP) {
                return (TIMESTAMP)datum;
            }
            DatabaseError.check_error(4, "getTIMESTAMP");
        }
        return null;
    }

    public synchronized TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof TIMESTAMPTZ) {
                return (TIMESTAMPTZ)datum;
            }
            DatabaseError.check_error(4, "getTIMESTAMPTZ");
        }
        return null;
    }

    public synchronized TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof TIMESTAMPLTZ) {
                return (TIMESTAMPLTZ)datum;
            }
            DatabaseError.check_error(4, "getTIMESTAMPLTZ");
        }
        return null;
    }

    public synchronized INTERVALDS getINTERVALDS(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof INTERVALDS) {
                return (INTERVALDS)datum;
            }
            DatabaseError.check_error(4, "getINTERVALDS");
        }
        return null;
    }

    public synchronized INTERVALYM getINTERVALYM(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof INTERVALYM) {
                return (INTERVALYM)datum;
            }
            DatabaseError.check_error(4, "getINTERVALYM");
        }
        return null;
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DatabaseError.check_error(4, "getARRAY");
        }
        return null;
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DatabaseError.check_error(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DatabaseError.check_error(4, "getOPAQUE");
        }
        return null;
    }

    public synchronized REF getREF(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DatabaseError.check_error(4, "getREF");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DatabaseError.check_error(4, "getCHAR");
        }
        return null;
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DatabaseError.check_error(4, "getRAW");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DatabaseError.check_error(4, "getBLOB");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DatabaseError.check_error(4, "getCLOB");
        }
        return null;
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DatabaseError.check_error(4, "getBFILE");
        }
        return null;
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return customDatumFactory.create(datum, 0);
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return oRADataFactory.create(datum, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.m_conn;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return new OracleResultSetMetaData(this.m_conn, (OracleStatement)this.m_scrollStmt, this.m_beginColumnIndex);
            }
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.m_rset.findColumn(string) - this.m_beginColumnIndex;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.m_usrFetchDirection = n;
        } else if (n == 1001 || n == 1002) {
            this.m_usrFetchDirection = n;
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 87);
        } else {
            DatabaseError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.m_rset.setFetchSize(n);
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.m_rset.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.m_type;
    }

    public int getConcurrency() throws SQLException {
        return this.m_update;
    }

    public void refreshRow() throws SQLException {
        if (!ScrollableResultSet.needIdentifier(this.m_type, this.m_update)) {
            DatabaseError.check_error(23, "refreshRow");
        }
        if (this.isValidRow(this.m_currentRow)) {
            int n = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.m_currentRow, this.getFetchSize(), n);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
            }
        } else {
            DatabaseError.throwSqlException(82, "refreshRow");
        }
    }

    public void setCurrentRowValueAt(Object object, int n, Object object2) throws SQLException {
        if (object instanceof UpdatableResultSet) {
            this.putCachedValueAt(this.m_currentRow, n, object2);
        } else {
            DatabaseError.throwSqlException(1);
        }
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.m_numRowsCached != 0) {
            return false;
        }
        if (this.m_numRowsCached == 0 && this.m_allRowsCached) {
            return true;
        }
        return !this.isValidRow(1);
    }

    boolean isValidRow(int n) throws SQLException {
        if (n > 0 && n <= this.m_numRowsCached) {
            return true;
        }
        if (n <= 0) {
            return false;
        }
        return this.cacheRowAt(n);
    }

    private boolean cacheRowAt(int n) throws SQLException {
        while (this.m_numRowsCached < n && this.m_rset.next()) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                byte[] byArray = this.m_rset.getBytes(i + 1);
                this.putCachedValueAt(this.m_numRowsCached + 1, i + 1, byArray);
            }
            ++this.m_numRowsCached;
        }
        if (this.m_numRowsCached < n) {
            this.m_allRowsCached = true;
            return false;
        }
        return true;
    }

    private int cacheAllRows() throws SQLException {
        while (this.m_rset.next()) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.putCachedValueAt(this.m_numRowsCached + 1, i + 1, this.m_rset.getBytes(i + 1));
            }
            ++this.m_numRowsCached;
        }
        this.m_allRowsCached = true;
        return this.m_numRowsCached;
    }

    int getColumnCount() throws SQLException {
        if (this.m_columnCount == 0) {
            int n = this.m_rset.statement.number_of_define_positions;
            this.m_columnCount = this.m_rset.statement.accessors != null && n > 0 ? n : this.getInternalMetadata().getColumnCount();
        }
        return this.m_columnCount;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.m_metadata == null) {
            this.m_metadata = this.m_rset.getMetaData();
        }
        return this.m_metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.m_allRowsCached) {
            this.cacheAllRows();
        }
        return this.m_numRowsCached;
    }

    private int get_refetch_size(int n, int n2, int n3) throws SQLException {
        int n4 = n3 == 1001 ? -1 : 1;
        int n5 = 0;
        if (this.m_refetchRowids == null) {
            this.m_refetchRowids = new Vector(10);
        } else {
            this.m_refetchRowids.removeAllElements();
        }
        while (n5 < n2 && this.isValidRow(n + n5 * n4)) {
            this.m_refetchRowids.addElement(this.getCachedDatumValueAt(n + n5 * n4, 1));
            ++n5;
        }
        return n5;
    }

    private OraclePreparedStatement prepare_refetch_statement(int n) throws SQLException {
        int n2;
        if (n < 1) {
            DatabaseError.throwSqlException(68);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_scrollStmt.getRevisedSql();
        String string2 = string.toUpperCase();
        String string3 = null;
        int n3 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = string2.charAt(n2);
            if (c == '\'') {
                if (bl3) {
                    bl3 = false;
                    continue;
                }
                bl3 = true;
                n4 = 0;
                n5 = 0;
                continue;
            }
            if (bl3) continue;
            if (!bl2) {
                if (n4 == 0 && c == 'W') {
                    n4 = 1;
                } else if (n4 == 1 && c == 'H') {
                    n4 = 2;
                } else if (n4 == 2 && c == 'E') {
                    n4 = 3;
                } else if (n4 == 3 && c == 'R') {
                    n4 = 4;
                } else if (n4 == 4 && c == 'E') {
                    n4 = 5;
                } else if (n4 == 5 && (c == ' ' || c == '\t' || c == '\n')) {
                    bl2 = true;
                } else {
                    n4 = 0;
                }
            }
            if (n5 == 0 && c == 'O') {
                n5 = 1;
                n6 = n2;
                continue;
            }
            if (n5 == 1 && c == 'R') {
                n5 = 2;
                continue;
            }
            if (n5 == 2 && c == 'D') {
                n5 = 3;
                continue;
            }
            if (n5 == 3 && c == 'E') {
                n5 = 4;
                continue;
            }
            if (n5 == 4 && c == 'R') {
                n5 = 5;
                continue;
            }
            if (!(n5 != 5 && n5 != 6 || c != ' ' && c != '\t' && c != '\n')) {
                n5 = 6;
                continue;
            }
            if (n5 == 6 && c == 'B') {
                n5 = 7;
                continue;
            }
            if (n5 == 7 && c == 'Y') {
                bl = true;
                string3 = string.substring(n6);
                stringBuffer.append(string.substring(0, n6));
                break;
            }
            n5 = 0;
        }
        if (!bl) {
            stringBuffer.append(string);
        }
        stringBuffer.append(bl2 ? " AND ( ROWID = :" + this.m_rset.statement.m_sql.generateParameterName() : " WHERE ( ROWID = :" + this.m_rset.statement.m_sql.generateParameterName());
        for (n2 = 0; n2 < n - 1; ++n2) {
            stringBuffer.append(" OR ROWID = :" + this.m_rset.statement.m_sql.generateParameterName());
        }
        stringBuffer.append(" ) ");
        if (bl) {
            stringBuffer.append(string3);
        }
        return (OraclePreparedStatement)this.m_conn.prepareStatement(((OracleStatement)this.m_scrollStmt).m_sql.getRefetchSqlForScrollableResultSet(this, n));
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        int n2 = this.m_scrollStmt.copyBinds(oraclePreparedStatement, 0);
        for (int i = 0; i < n; ++i) {
            oraclePreparedStatement.setROWID(n2 + i + 1, (ROWID)this.m_refetchRowids.elementAt(i));
        }
    }

    private void save_refetch_results(OracleResultSet oracleResultSet, int n, int n2, int n3) throws SQLException {
        int n4;
        int n5 = n4 = n3 == 1001 ? -1 : 1;
        while (oracleResultSet.next()) {
            ROWID rOWID = oracleResultSet.getROWID(1);
            boolean bl = false;
            int n6 = n;
            while (!bl && n6 < n + n2 * n4) {
                if (((ROWID)this.getCachedDatumValueAt(n6, 1)).stringValue().equals(rOWID.stringValue())) {
                    bl = true;
                    continue;
                }
                n6 += n4;
            }
            if (!bl) continue;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.putCachedValueAt(n6, i + 1, oracleResultSet.getOracleObject(i + 1));
            }
        }
    }

    private Object getCachedValueAt(int n, int n2) throws SQLException {
        try {
            return this.m_cache.get(n, n2);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
            return null;
        }
    }

    private Datum getCachedDatumValueAt(int n, int n2) throws SQLException {
        Object object = null;
        try {
            object = this.m_cache.get(n, n2);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        Datum datum = null;
        if (object != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else if (((byte[])object).length > 0) {
                int n3 = this.getInternalMetadata().getColumnType(n2);
                int n4 = this.getInternalMetadata().getColumnDisplaySize(n2);
                int n5 = this.m_scrollStmt.getMaxFieldSize();
                if (n5 > 0 && n5 < n4) {
                    n4 = n5;
                }
                String string = null;
                if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003) {
                    string = this.getInternalMetadata().getColumnTypeName(n2);
                }
                int n6 = SQLUtil.get_internal_type(n3);
                short s = this.m_rset.statement.accessors[n2 - 1].formOfUse;
                datum = s == 2 && (n6 == 96 || n6 == 1 || n6 == 8 || n6 == 112) ? SQLUtil.makeNDatum(this.m_conn, (byte[])object, n6, string, s, n4) : SQLUtil.makeDatum(this.m_conn, (byte[])object, n6, string, n4);
                try {
                    this.m_cache.put(n, n2, datum);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                try {
                    this.m_cache.put(n, n2, null);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            }
        }
        return datum;
    }

    private void putCachedValueAt(int n, int n2, Object object) throws SQLException {
        try {
            this.m_cache.put(n, n2, object);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    private void removeCachedRowAt(int n) throws SQLException {
        try {
            this.m_cache.remove(n);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public static boolean needIdentifier(int n, int n2) {
        return (n != 1003 || n2 != 1007) && (n != 1004 || n2 != 1007);
    }

    public static boolean needCache(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }

    public static boolean supportRefreshRow(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }

    int getFirstUserColumnIndex() {
        return this.m_beginColumnIndex;
    }
}

