/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class OracleXid
implements Xid,
Serializable {
    private int formatId;
    private byte[] gtrid = null;
    private byte[] bqual = null;
    private byte[] txctx = null;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private int state;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public OracleXid(int n, byte[] byArray, byte[] byArray2) throws XAException {
        this(n, byArray, byArray2, null);
    }

    public OracleXid(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws XAException {
        this.formatId = n;
        if (byArray != null && byArray.length > 64) {
            throw new XAException(-4);
        }
        this.gtrid = byArray;
        if (byArray2 != null && byArray2.length > 64) {
            throw new XAException(-4);
        }
        this.bqual = byArray2;
        this.txctx = byArray3;
        this.state = 0;
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public byte[] getTxContext() {
        return this.txctx;
    }

    public void setTxContext(byte[] byArray) {
        this.txctx = byArray;
    }

    public static final boolean isLocalTransaction(Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        if (byArray == null) {
            return true;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }
}

