package jp.ossc.petstore.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.model.Customer;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.common.Cart;
import jp.ossc.petstore.dto.peerdto.OrderPeerDTO;

/**
 * ANV
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class OrderAction extends BaseAction {

	/**
	 * peer
	 */
	private IPeer orderPeer;

	/**
	 * peerݒ
	 * @param orderPeer peer
	 */
	public void setOrderPeer(IPeer orderPeer) {
		this.orderPeer = orderPeer;
	}

	/**
	 * ANVsB<br>
	 * ƖĂяoAsʂɉđJڐ肷B
	 * <ul>
	 * <li>IꍇAJ[gNAusuccessvɑJڂB
	 * <li>IȊȌꍇAG[bZ[WۑufailurevɑJڂB
	 * </ul>
	 * @param mapping ActionMapping
	 * @param form ActionForm
	 * @param request HTTPNGXg
	 * @param response HTTPX|X
	 * @return ʑJڐ
	 * @throws Exception ActionsG[
	 */
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		// ZbV擾
		HttpSession session = request.getSession(false);

		// ڋq擾
		Customer customer =
			(Customer)session.getAttribute(OpenstandiaConst.ENV_SES_ATRBT_CUSTOMER);

		// J[g擾
		Cart cart = (Cart)session.getAttribute(OpenstandiaConst.ENV_SES_ATRBT_CART);

		// J[g`FbN
		if (cart == null || cart.isEmpty()) {
			return mapping.findForward(OpenstandiaConst.ENV_FORWARD_CART_EMPTY);
		}
		
		// DTO̍쐬
		OrderPeerDTO dto = new OrderPeerDTO();
		dto.setCustomer(customer);
		dto.setCart(cart);
		
		// s
		orderPeer.execute(dto);

		// Xe[^X`FbN
		if (dto.getStatus() != OpenstandiaConst.ENV_STATUS_NORMAL_END) {
			saveMessages(request, dto.getActionMessages());
			return mapping.findForward(OpenstandiaConst.ENV_FORWARD_FAILURE);
		}
		
		// J[gNA
		cart.clear();

		// hcNGXgɊi[
		request.setAttribute(OpenstandiaConst.ENV_REQ_ATRBT_ORDER_ID, dto.getOrderId());

		return mapping.findForward(OpenstandiaConst.ENV_FORWARD_SUCCESS);
		
	}
}
