package jp.ossc.petstore.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;

import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.common.Cart;

/**
 * J[gύXANV
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class UpdateCartAction extends BaseAction {

	/**
	 * J[gύXANVsB<br>
	 * J[g̏iw肳ꂽiɕύXB
	 * @param mapping ActionMapping
	 * @param form ActionForm
	 * @param request HTTPNGXg
	 * @param response HTTPX|X
	 * @return ʑJڐ
	 * @throws Exception ActionsG[
	 */
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		// p[^擾
		DynaActionForm bean = (DynaActionForm)form;
		String[] ids = (String[])bean.get("product_id");
		String[] quantities = (String[])bean.get("quantity");
		
		// ZbV擾
		HttpSession session = request.getSession(false);
		
		// ZbVJ[gIuWFNg擾
		Cart cart = (Cart)session.getAttribute(OpenstandiaConst.ENV_SES_ATRBT_CART);

		// J[g݂ȂA܂́AJ[g̏ꍇemptyʂ֑J
		if (cart == null || cart.isEmpty()) {
			return mapping.findForward(OpenstandiaConst.ENV_FORWARD_CART_EMPTY);
		}
		
		// XV
		boolean updated = false;

		for (int i=0; i<ids.length; i++) {

			// Yi̐ʂύX
			updated =
				cart.updateQuantity(Integer.parseInt(ids[i]), Integer.parseInt(quantities[i]));
			
			// J[gɎw肳ꂽi݂ȂꍇG[
			if (!updated) {
				// G[bZ[Wݒ
				ActionMessage msg = new ActionMessage("errors.cart.product_not_exist", ids[i]);
				ActionMessages msgs = new ActionMessages();
				msgs.add("UpdateCart", msg);
				saveMessages(request, msgs);
				return mapping.findForward(OpenstandiaConst.ENV_FORWARD_FAILURE);
			}
		}

		return mapping.findForward(OpenstandiaConst.ENV_FORWARD_SUCCESS);
	}
}
