package jp.ossc.petstore.common;

import java.util.ArrayList;
import java.util.List;

import jp.ossc.petstore.model.Product;

/**
 * J[gNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class Cart {

	/**
	 * J[ge
	 */
	private List<CartItem> itemList = new ArrayList<CartItem>();

	/**
	 * J[geXg擾
	 * @return J[geXg
	 */
	public List<CartItem> getItemList() {
		return itemList;
	}


	/**
	 * iǉ<br>
	 * w肳ꂽiJ[gɑ݂ꍇ́Aw肳ꂽZB
	 * @param product i
	 * @param quantity 
	 */
	public void addItem(Product product, int quantity) {

		CartItem item = getItem(product.getId());

		if (item == null) {
			item = new CartItem(product, quantity);
			itemList.add(item);

		} else {
			item.setQuantity(item.getQuantity() + quantity);
		}

	}


	/**
	 * ύX<br>
	 * @param id ihc
	 * @param quantity 
	 * @return true:w肳ꂽiJ[gɑ݂ꍇ<br>
	 *          false:w肳ꂽiJ[gɑ݂Ȃꍇ
	 */
	public boolean updateQuantity(int id, int quantity) {

		boolean updated = false;
		
		CartItem item = getItem(id);

		if (item != null) {
			item.setQuantity(quantity);
			updated = true;
		}
		
		return updated;
	}


	/**
	 * i폜<br>
	 * @param id ihc
	 * @return true:w肳ꂽiJ[gɑ݂ꍇ<br>
	 *          false:w肳ꂽiJ[gɑ݂Ȃꍇ
	 */
	public boolean deleteItem(int id) {

		boolean deleted = false;
		List<CartItem> newItemList = new ArrayList<CartItem>();
		
		for (CartItem item : itemList) {
			if (item.getId() != id) {
				newItemList.add(item);
			} else {
				deleted = true;
			}
		}
		
		itemList.clear();
		itemList.addAll(newItemList);
		
		return deleted;
	}


	/**
	 * vz擾<br>
	 * @return vz
	 */
	public int getTotalPrice() {

		int totalPrice = 0;
		
		for (CartItem item : itemList) {
			totalPrice += item.getTotalPrice();
		}

		return totalPrice;
	}


	/**
	 * vi擾<br>
	 * @return vi
	 */
	public int getItemSize() {
		return itemList.size();
	}

	/**
	 * J[gi0<br>
	 * @return true:0̏ꍇAfalse:0ȊȌꍇ
	 */
	public boolean isEmpty() {
		return itemList.isEmpty();
	}

	/**
	 * J[geNA<br>
	 */
	public void clear() {
		itemList.clear();
	}

	/**
	 * i擾<br>
	 * @param id ihc
	 * @return J[geIuWFNg
	 */
	private CartItem getItem(int id) {

		for (CartItem item : itemList) {
			if (item.getId() == id) {
				return item;
			}
		}

		return null;
	}
}
