package jp.ossc.petstore.dao.impl;

import java.util.List;

import jp.ossc.petstore.dao.ICategoryDAO;
import jp.ossc.petstore.dao.impl.BaseDAO;
import jp.ossc.petstore.model.Category;

/**
 * JeSe[uANZXNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class CategoryDAO extends BaseDAO implements ICategoryDAO {
	
	private static final String HQL_GET_MIN_CATEGORY_ID =
		"select min(category.id) from Category as category";
	

	/* ( Javadoc)
	 * @see jp.ossc.petstore.dao.ICategoryDAO#getCategoryList()
	 */
	public List getCategoryList() {
		return getHibernateTemplate().loadAll(Category.class);
	}

	/* ( Javadoc)
	 * @see jp.ossc.petstore.dao.ICategoryDAO#getMinCategoryId()
	 */
	public String getMinCategoryId() {
		
		String minCategoryId = null;
		List list = getHibernateTemplate().find(HQL_GET_MIN_CATEGORY_ID);
		
		if (list.size() > 0) {
			Integer intMinCategoryId = (Integer)list.get(0);
			if (intMinCategoryId != null) {
				minCategoryId = intMinCategoryId.toString();
			}
		}
		
		return minCategoryId;
	}

}
