package jp.ossc.petstore.dao.impl;

import java.util.List;

import jp.ossc.petstore.dao.IProductDAO;
import jp.ossc.petstore.dao.impl.BaseDAO;
import jp.ossc.petstore.model.Product;

/**
 * ie[uANZXNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class ProductDAO extends BaseDAO implements IProductDAO {

	private static final String HQL_GET_PRODUCT_LIST =
		"from Product where category_id = ?";
	

	/* ( Javadoc)
	 * @see jp.ossc.petstore.dao.IProductDAO#getProductList(int)
	 */
	public List getProductList(String categoryId) {
		return getHibernateTemplate().find(HQL_GET_PRODUCT_LIST, new Integer(categoryId));
	}

	/* ( Javadoc)
	 * @see jp.ossc.petstore.dao.IProductDAO#getProduct(int)
	 */
	public Product getProduct(String productId) {
		return (Product)getHibernateTemplate().get(Product.class, new Integer(productId));
	}

}
