package jp.ossc.petstore.peer.impl;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.peer.impl.BasePeer;
import jp.ossc.petstore.dto.BaseDTO;
import jp.ossc.petstore.function.ICategoryFanction;
import jp.ossc.petstore.dto.peerdto.ShowCategoryPeerDTO;
import jp.ossc.petstore.dto.functiondto.CategoryFunctionDTO;

/**
 * JeS\peerNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class ShowCategoryPeer extends BasePeer implements IPeer {

	/**
	 * JeSt@NV
	 */
	private ICategoryFanction categoryFunction;
	
	/**
	 * JeSt@NVݒ
	 * @param categoryFunction JeSt@NV
	 */
	public void setCategoryFunction(ICategoryFanction categoryFunction) {
		this.categoryFunction = categoryFunction;
	}


	/**
	 * JeS\Ɩs<br>
     * JeS񃊃Xg擾B<br>
     * JeS񃊃Xg擾łȂꍇ̓G[bZ[Wݒ肷B
	 * @param dto DTOIuWFNg
	 */
	public void execute(BaseDTO dto) {
		
		// dtoLXg
		ShowCategoryPeerDTO showCategoryPeerDTO = (ShowCategoryPeerDTO)dto;
		
		// CategoryFunctionDTO
		CategoryFunctionDTO categoryFunctionDTO = new CategoryFunctionDTO();
		
		// JeSꗗ擾
		categoryFunction.getCategoryList(categoryFunctionDTO);
		
		// Xe[^X`FbN
		if (categoryFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
			
			// Xe[^Xݒ
			showCategoryPeerDTO.setStatus(categoryFunctionDTO.getStatus());
			
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage("errors.category_not_exist");
			ActionMessages msgs = new ActionMessages();
			msgs.add("ShowCategory", msg);
			showCategoryPeerDTO.setActionMessages(msgs);
		}
		
		// JeSꗗݒ
		showCategoryPeerDTO.setCategoryList(categoryFunctionDTO.getCategoryList());
	}


}
