package jp.ossc.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * 񕪊Ant^XNNXłB<br>
 * @author S.Fujii
 * @version 1.0
 * @since 1.0
 */
public class Split extends Task {

    /**
     * 񕪊Ώە<br>
     */
    protected String target;

    /**
     * 镶(f~^[)<br>
     *  Kl : ,<br>
     */
    protected String delim;

    /**
     * propertyƂĕۑۂnamel<br>
     */
    protected String name;

    /**
     * ʁAԖڂ̕propertyƂĕۑۂvaluelƂ邩indexl<br>
     */
    protected Integer index;

    /**
     * property㏑邩ǂ<br>
     * true : ㏑ / false : Ȃ<br>
     */
    protected Boolean override;

    /**
     * RXgN^[<br>
     */
    public Split () {
        super();
        this.target = null;
        this.delim = ",";
        this.name = null;
        this.index = null;
        this.override = false;
    }

    /**
     * 镶(f~^[)擾<br>
     * @return 镶(f~^[)
     */
    public String getDelim() {
        return delim;
    }

    /**
     * 镶(f~^[)ݒ肷<br>
     * @param lDelim 镶(f~^[)
     */
    public void setDelim(String lDelim) {
        this.delim = lDelim;
    }

    /**
     * ʁAԖڂ̕propertyƂĕۑۂvaluelƂ邩indexl擾<br>
     * @return ʁAԖڂ̕propertyƂĕۑۂvaluelƂ邩indexl
     */
    public int getIndex() {
        return index;
    }

    /**
     * ʁAԖڂ̕propertyƂĕۑۂvaluelƂ邩indexlݒ肷<br>
     * @param lIndex ʁAԖڂ̕propertyƂĕۑۂvaluelƂ邩indexl
     */
    public void setIndex(int lIndex) {
        this.index = new Integer(lIndex);
    }

    /**
     * propertyƂĕۑۂnamel擾<br>
     * @return propertyƂĕۑۂnamel
     */
    public String getName() {
        return name;
    }

    /**
     * propertyƂĕۑۂnamelݒ肷<br>
     * @param lName propertyƂĕۑۂnamel
     */
    public void setName(String lName) {
        this.name = lName;
    }

    /**
     * 񕪊Ώە擾<br>
     * @return 񕪊Ώە
     */
    public String getTarget() {
        return target;
    }

    /**
     * 񕪊Ώەݒ肷<br>
     * @param lTarget 񕪊Ώە
     */
    public void setTarget(String lTarget) {
        this.target = lTarget;
    }

    /**
     * property㏑邩ǂ擾<br>
     * @return true : ㏑ / false : Ȃ
     */
    public Boolean isOverride() {
        return override;
    }

    /**
     * property㏑邩ǂݒ肷<br>
     * @param override true : ㏑ / false : Ȃ
     */
    public void setOverride(boolean override) {
        this.override = Boolean.valueOf(override);
    }

    /**
     * Ant^XNs<br>
     * @throws BuildException
     * @see org.apache.tools.ant.Task#execute()
     */
    public void execute() throws BuildException {

        // `FbN
        checkAttribute();

        // 񕪊
        final String delimEsc = delim.replaceAll("\\\\", "\\\\\\\\");
        final String[] values = target.split(delimEsc);

        // propertyɕۑ
        if (override) {
            final String value = getProject().getProperty(name);
            if (value == null) {
                getProject().setNewProperty(name, values[index]);
            } else {
                getProject().setProperty(name, values[index]);
            }
        } else {
            getProject().setNewProperty(name, values[index]);
        }

    }

    /**
     * `FbN<br>
     * (1) targetAnameAindex͕K{<br>
     */
    protected void checkAttribute() {
        if (getProject() == null) {
            throw new IllegalStateException("project has not been set");
        } else if (target == null || name == null || index == null) {
            throw new BuildException(
                "You must specify target, name, index", getLocation());
        } else {
            // Ȃ
        }
    }

}
