#! /bin/sh

main() {

##### 初期設定 #####
CONF_DIR=conf
LOGROTATE_DIR=logrotate.d
LOGROTATE_FILE_NAME=openstandia-httpd

##### 引数取得 #####
SUB_NO=$1
SRC_DIR=$2
INSTALL_DIR=$3
CONF_1=$4
CONF_2=$5

##### 初期処理 #####
APACHE_HOME=${INSTALL_DIR}/
SRC_DIR=${SRC_DIR}/

##### インストール #####
# httpd.confファイルの選択(sub番号により処理分岐)
SRC_CONF_DIR=${SRC_DIR}${CONF_DIR}/linux/
if [ "${SUB_NO}" = "1" ]; then
	echo ${CONF_1}を使用します。
	cp -pf "${SRC_CONF_DIR}${CONF_1}" "${APACHE_HOME}${CONF_DIR}/httpd.conf"
elif [ "${SUB_NO}" = "2" ]; then
	echo ${CONF_2}を使用します。
	cp -pf "${SRC_CONF_DIR}${CONF_2}" "${APACHE_HOME}${CONF_DIR}/httpd.conf"
else
	echo apache標準のhttpd.confを使用します。
fi

# logrotateファイルの配置
SRC_LOGROTATE_DIR=${SRC_DIR}${LOGROTATE_DIR}/linux/
mkdir -p "/etc/${LOGROTATE_DIR}"
cp -pf "${SRC_LOGROTATE_DIR}${LOGROTATE_FILE_NAME}" "/etc/${LOGROTATE_DIR}"

}
main $*
