#! /bin/sh

main() {

##### 初期設定 #####
BIN_DIR=bin
HTTPD_EXE=apachectl

##### 引数取得 #####
PRODUCT_NAME=$1
PRODUCT_VER=$2
APACHE_HOME=$3

##### 初期処理 #####
APACHE_HOME=${APACHE_HOME}/

##### バージョンチェック #####
cd "${APACHE_HOME}${BIN_DIR}"
if [ ! -f "${HTTPD_EXE}" ]; then
	echo ${PRODUCT_NAME}は、インストールされていません。
	exit 0
fi
INSTALLED_VER=`"./${HTTPD_EXE}" -v | grep 'Server version' | awk '{print $3;}' | awk -F '/' '{print $2;}'`
if [ "${INSTALLED_VER}" = "${PRODUCT_VER}" ]; then
	echo "${PRODUCT_NAME}は、最新版がインストールされています。(Ver.${INSTALLED_VER})"
	exit 0
fi
if [ "${INSTALLED_VER}" = "2.2.x" ]; then
	echo "処理なし" > /dev/nul
else
	echo "${PRODUCT_NAME}は、アップデート対象のバージョンではありません。(Ver.${INSTALLED_VER})"
	exit 0
fi

##### アップデート #####
echo "${PRODUCT_NAME}のアップデート処理をします。(Ver.${INSTALLED_VER} -> Ver.${PRODUCT_VER})"
# ここにアップデート処理を記述する(パッチ当てなど)

}

main $*
