#! /bin/sh

main() {

##### 初期設定 #####
BIN_DIR=bin
JBOSS_EXE=run.sh

##### 引数取得 #####
PRODUCT_NAME=$1
PRODUCT_VER=$2
JBOSS_HOME=$3

##### 初期処理 #####
JBOSS_HOME=${JBOSS_HOME}/

##### バージョンチェック #####
cd "${JBOSS_HOME}${BIN_DIR}"
if [ ! -f "${JBOSS_EXE}" ]; then
	echo ${PRODUCT_NAME}は、インストールされていません。
	exit 1
fi
INSTALLED_VER=`./run.sh -V | grep 'build' | awk '{print $2;}'`
if [ "${INSTALLED_VER}" = "${PRODUCT_VER}" ]; then
	echo "${PRODUCT_NAME}は、最新版がインストールされています。(Ver.${INSTALLED_VER})"
	exit 1
fi
if [ "${INSTALLED_VER}" = "4.2.1.GA" ]; then
	echo "処理なし" > /dev/nul
else
	echo "${PRODUCT_NAME}は、アップデート対象のバージョンではありません。(Ver.${INSTALLED_VER})"
	exit 1
fi

##### アップデート #####
echo "${PRODUCT_NAME}のアップデート処理をします。(Ver.${INSTALLED_VER} -> Ver.${PRODUCT_VER})"
exit 0

}

main $*
