#! /bin/sh

main() {

##### 初期設定 #####
LOOP_NUM=12
ROOT_PASSWORD=root

##### 引数取得 #####
SRC_DIR=$1
FILENAME=$2
TMP_DIR=$3
DEST_DIR=$4
MYSQL_HOME=$5

##### 初期処理 #####
SRC_DIR=${SRC_DIR}/
TMP_DIR=${TMP_DIR}/

##### 旧ファイル退避 #####
mkdir -p "${MYSQL_HOME}"
mkdir -p "${TMP_DIR}/mysql"
mv -f ${MYSQL_HOME}/* "${TMP_DIR}mysql"
rm -rf "${MYSQL_HOME}"

##### my.cnfファイルの選定 #####
cd "${SRC_DIR}"
if [ ! -f "my.cnf" ]; then
	MYSQL_CNF_FILE=/usr/local/mysql/support-files/my-medium.cnf
else
	MYSQL_CNF_FILE=${SRC_DIR}my.cnf
fi

##### インストール ######
cd "${TMP_DIR}"
cp -pf "${SRC_DIR}${FILENAME}" "${TMP_DIR}"
tar -xzvf "${FILENAME}"
rm -rf "${FILENAME}"
mv "${TMP_DIR}${DEST_DIR}" "${MYSQL_HOME}"
cd "${MYSQL_HOME}"

##### 旧ファイル戻し #####
cp -prf ${TMP_DIR}mysql/* "${MYSQL_HOME}"
rm -rf "${TMP_DIR}/mysql"

##### MySQLセットアップ #####
rm -f /usr/local/mysql
ln -s "${MYSQL_HOME}" /usr/local/mysql
cd /usr/local/mysql
chown -R mysql:mysql .
./scripts/mysql_install_db --user=mysql

##### my.cnfファイルの配置 #####
cp -pf "${MYSQL_CNF_FILE}" ./my.cnf

##### 動作に必要なディレクトリの作成 #####
mkdir -p /usr/local/mysql/data/log
mkdir -p /usr/local/mysql/data/binlog

##### 権限設定 #####
chown -R mysql:mysql .

##### rootユーザーパスワード変更 #####
/usr/local/mysql/bin/mysqld_safe --defaults-file=/usr/local/mysql/my.cnf --user=mysql 1> /dev/nul 2> /dev/nul &
for i in `seq 1 ${LOOP_NUM}`; do
	sleep 10
	/usr/local/mysql/bin/mysqladmin -u root status 1> /dev/nul 2> /dev/nul
	EXIT_CODE=$?
	if [ "${EXIT_CODE}" = "0" ]; then
		echo MySQLの起動確認ができました。
		MODE=change_password
		break
	else
		/usr/local/mysql/bin/mysqladmin -u root -p${ROOT_PASSWORD} status 1> /dev/nul 2> /dev/nul
		EXIT_CODE=$?
		if [ "${EXIT_CODE}" = "0" ]; then
			echo MySQLの起動確認ができました。
			MODE=end
			break
		else
			if [ "${i}" = "${LOOP_NUM}" ]; then
				echo MySQLの起動確認ができませんでした。
				MODE=end
				break
			fi
			echo "MySQLの起動確認ができないためリトライします。(${i})"
		fi
	fi
done

if [ "${MODE}" = "change_password" ]; then
	/usr/local/mysql/bin/mysqladmin -u root password ${ROOT_PASSWORD}
fi

# /usr/local/mysql/bin/mysqladmin -u root -p${ROOT_PASSWORD} shutdown

exit 0

}

main $*
