#! /bin/sh

main() {

##### 初期設定 #####
LOOP_NUM=12
ROOT_PASSWORD=root

##### MySQLの強制終了を試みる #####
/usr/local/mysql/bin/mysqladmin -u root -p${ROOT_PASSWORD} shutdown 1> /dev/nul 2> /dev/nul
for i in `seq 1 ${LOOP_NUM}`; do
	sleep 5
	/usr/local/mysql/bin/mysqladmin -u root status 1> /dev/nul 2> /dev/nul
	EXIT_CODE=$?
	if [ "${EXIT_CODE}" = "0" ]; then
		if [ "${i}" = "${LOOP_NUM}" ]; then
			echo MySQLの終了確認ができませんでした。
			break
		fi
		echo "MySQLの終了確認ができないためリトライします。(${i})"
	else
		echo MySQLの終了確認ができました。
		break
	fi
done

##### アンインストール #####
rm -f /usr/local/mysql/configure
rm -f /usr/local/mysql/COPYING
rm -f /usr/local/mysql/EXCEPTIONS-CLIENT
rm -f /usr/local/mysql/INSTALL-BINARY
rm -f /usr/local/mysql/README
rm -Rf /usr/local/mysql/bin
rm -Rf /usr/local/mysql/docs
rm -Rf /usr/local/mysql/include
rm -Rf /usr/local/mysql/lib
rm -Rf /usr/local/mysql/man
rm -Rf /usr/local/mysql/mysql-test
rm -Rf /usr/local/mysql/scripts
rm -Rf /usr/local/mysql/share
rm -Rf /usr/local/mysql/sql-bench
rm -Rf /usr/local/mysql/support-files
rm -Rf /usr/local/mysql/tests
rm -f /usr/local/mysql

}

main $*
