#! /bin/sh

main() {

##### 初期設定 #####
BIN_DIR=bin
JBOSS_EXE=run.sh

##### 引数取得 #####
PRODUCT_NAME=$1
PRODUCT_VER=$2
TMP_DIR=$3
SRC_DIR=$4
JBOSS_HOME=$5
BUILD_XML=$6
ANT_ARGS=$7

##### 初期処理 #####
TMP_DIR=${TMP_DIR}/
SRC_DIR=${SRC_DIR}/
ANT_ARGS=`echo "${ANT_ARGS}" | sed -e "s/\\\\\\\\/ /g"`

##### 存在チェック #####
cd "${JBOSS_HOME}/${BIN_DIR}"
if [ ! -f "${JBOSS_EXE}" ]; then
	echo JBossがインストールされていません。
	exit 0
fi

##### アップデート #####
echo "${PRODUCT_NAME}のアップデート処理をします。(Ver.${PRODUCT_VER})"
# ここにアップデート処理を記述する(パッチ当てなど)

cp -pf "${SRC_DIR}${BUILD_XML}" "${TMP_DIR}"
cd "${TMP_DIR}"
ant ${ANT_ARGS} -f "${BUILD_XML}"

}

main $*
