#! /bin/sh

main() {

##### 初期設定 #####
LOOP_NUM=12
ROOT_PASSWORD=postgres

##### 引数取得 #####
ARC_DIR=$1
ARC_FILENAME=$2
SRC_DIR=$3
DEST_DIR=$4
INSTALL_DIR=$5

##### ログディレクトリ作成 #####
mkdir -p ${INSTALL_DIR}/logs

##### アクセス権限設定 #####
chown -R postgres:postgres ${INSTALL_DIR}

##### データベース初期化 #####
sudo -u postgres ${INSTALL_DIR}/bin/initdb --encoding=UTF-8 --no-locale -D ${INSTALL_DIR}/data

##### サーバー起動 #####
sudo -u postgres ${INSTALL_DIR}/bin/pg_ctl -o "-i" -D ${INSTALL_DIR}/data -l ${INSTALL_DIR}/logs/postgresql.log start
for i in `seq 1 ${LOOP_NUM}`; do
	sleep 10
	sudo -u postgres ${INSTALL_DIR}/bin/pg_ctl -D ${INSTALL_DIR}/data status > /dev/nul
	EXIT_CODE=$?
	if [ "${EXIT_CODE}" = "0" ]; then
		echo PostgreSQLの起動確認ができました。
		break
	else
		if [ "${i}" = "${LOOP_NUM}" ]; then
			echo PostgreSQLの起動確認ができませんでした。
			break
		fi
		echo "PostgreSQLの起動確認ができないためリトライします。(${i})"
	fi
done

##### パスワード変更 #####
sudo -u postgres ${INSTALL_DIR}/bin/psql -d postgres -c "alter user postgres with password '${ROOT_PASSWORD}';" 1>/dev/nul

##### サーバー停止 #####
sudo -u postgres ${INSTALL_DIR}/bin/pg_ctl -m immediate -D ${INSTALL_DIR}/data stop

}

main $*
