#! /bin/sh

main() {

##### 初期設定 #####
# Stack内のbinディレクトリパス
STACK_BIN=bin
# 外部実行タイムアウト時間(ms)
PROCESS_TIMEOUT=1200000
# ダウンロードのみ
DOWNLOAD_ONLY=false
# 起動時に読み込むスタックファイル
DEFAULT_STACK_XML=
# Stack内のANT_HOMEのパス
ANT_DIR=apache-ant-1.7.0
STACK_ANT_HOME=lib/${ANT_DIR}


##### 初期処理 #####
CURRENT_DIR=`pwd`
BASEDIR=`dirname $0`
if [ "${CURRENT_DIR}" = "/" ]; then
	CURRENT_DIR=${BASEDIR}
else
	CURRENT_DIR=${CURRENT_DIR}/${BASEDIR}
fi
chmod 755 "${CURRENT_DIR}/${STACK_ANT_HOME}/bin/ant" > /dev/nul


##### 実行ユーザー権限チェック #####
sh ${CURRENT_DIR}/${STACK_BIN}/CheckAuthority.sh
if [ $? -ne 0 ]; then
	echo 実行ユーザーがrootでないため処理を続行できません。
	exit 1
fi


##### javaインストールチェック #####
sh ${CURRENT_DIR}/${STACK_BIN}/CheckInstalledJava.sh
if [ $? -ne 0 ]; then
	echo javaがインストールされていないため処理を続行できません。
	exit 1
fi


##### 起動 #####
cd ${CURRENT_DIR}
java -DprocessTimeout=${PROCESS_TIMEOUT} -DdownloadOnly=${DOWNLOAD_ONLY} -DdefaultStackXml=${DEFAULT_STACK_XML} -jar openstandiainstaller.jar &

}

main $*
