package jp.ossc.tools.ant.types;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.tools.ant.types.XMLCatalog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExtendsXMLCatalog extends XMLCatalog {

    private boolean validating = false;

    public boolean isValidating() {
        return validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public InputSource resolveEntity(String publicId, String systemId)
        throws SAXException, IOException {
        if (validating) {
            return super.resolveEntity(publicId, systemId);
        } else {
            final URL url = this.getClass().getResource("dummy.dtd");
            InputStream reader = url.openStream();
            return new InputSource(reader);
        }
    }

}
