/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading;

import java.io.Serializable;
import jp.sf.orangesignal.trading.Account;

public class VirtualAccount
implements Account,
Serializable {
    private static final long serialVersionUID = 5749635909805874526L;
    private double cash;
    private boolean unlimited = true;

    public VirtualAccount() {
    }

    public VirtualAccount(double cash) {
        this(cash, true);
    }

    public VirtualAccount(double cash, boolean unlimited) {
        this.cash = cash;
        this.unlimited = unlimited;
    }

    @Override
    public double getCash() {
        return this.cash;
    }

    public void setCash(double cash) {
        this.cash = cash;
    }

    @Override
    public double getInterestRate() {
        return 0.0;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    @Override
    public void deposit(double amount) {
        if (amount <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.cash += amount;
    }

    @Override
    public boolean withdraw(double amount) {
        if (amount <= 0.0) {
            throw new IllegalArgumentException();
        }
        double balance = this.cash - amount;
        if (!this.unlimited && balance < 0.0) {
            return false;
        }
        this.cash = balance;
        return true;
    }
}

