/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.strategy.filters;

import jp.sf.orangesignal.ta.TechnicalAnalysis;
import jp.sf.orangesignal.ta.dataset.StandardDataset;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

public class VolumeAverageFilter
extends TradingStrategySupport {
    private int period = 1;
    private double upper;
    private double lower = 1000.0;
    private Number[] volume;

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double upper) {
        this.upper = upper;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double lower) {
        this.lower = lower;
    }

    @Override
    public void prepare() {
        StandardDataset dataset = this.getDataset();
        this.volume = TechnicalAnalysis.sma((Number[])dataset.getTechnicalVolume(), (int)this.period);
    }

    @Override
    public boolean execute() {
        Number value = this.volume[this.getCurrentDataIndex()];
        return value != null && (this.upper > 0.0 && value.doubleValue() > this.upper || this.lower > 0.0 && value.doubleValue() < this.lower);
    }

    @Override
    public void close() {
        this.volume = null;
    }
}

