/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.stats;

import java.util.Date;
import java.util.Map;
import jp.sf.orangesignal.trading.backtest.Backtester;
import jp.sf.orangesignal.trading.stats.Stats;
import jp.sf.orangesignal.trading.stats.WinLossSummary;

public class Summary
extends WinLossSummary {
    private static final long serialVersionUID = 1L;
    protected Map<String, Stats> statsMap;
    protected WinLossSummary winSummary;
    protected WinLossSummary lossSummary;
    protected Date startDate;
    protected Date endDate;

    public Summary(Map<String, Stats> statsMap, Backtester backtester) {
        this.statistics(statsMap, backtester);
    }

    protected void statistics(Map<String, Stats> statsMap, Backtester backtester) {
        super.statistics(statsMap, backtester.getInitialCapital());
        this.statsMap = statsMap;
        this.winSummary = new WinLossSummary(statsMap, this.initialCapital){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isStatistics(Stats stats) {
                return stats.getTrades() > 0 && stats.getNetProfit() > 0.0;
            }
        };
        this.lossSummary = new WinLossSummary(statsMap, this.initialCapital){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isStatistics(Stats stats) {
                return stats.getTrades() > 0 && stats.getNetProfit() <= 0.0;
            }
        };
        this.startDate = backtester.getStartDate();
        this.endDate = backtester.getEndDate();
    }

    @Override
    protected boolean isStatistics(Stats stats) {
        return true;
    }

    public Map<String, Stats> getStatsMap() {
        return this.statsMap;
    }

    public WinLossSummary getWinSummary() {
        return this.winSummary;
    }

    public WinLossSummary getLossSummary() {
        return this.lossSummary;
    }

    public int getValidCount() {
        return this.winSummary.getCount() + this.lossSummary.getCount();
    }

    public double getPercentValidCount() {
        return (double)this.getValidCount() / (double)this.getCount();
    }

    public int getWinCount() {
        return this.winSummary.getCount();
    }

    public double getPercentWinCount() {
        return this.getAverage(this.getWinCount());
    }

    public int getLossCount() {
        return this.lossSummary.getCount();
    }

    public double getPercentLossCount() {
        return this.getAverage(this.getLossCount());
    }

    public double getAverageNetProfitByValidCount() {
        return this.getNetProfit() / (double)this.getValidCount();
    }

    public double getAverageNetProfitByTrades() {
        return this.getNetProfit() / (double)this.getTrades();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }
}

