/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.filters;

import static jp.sf.orangesignal.ta.TechnicalAnalysis.sma;
import static jp.sf.orangesignal.ta.TechnicalAnalysis.sub;
import jp.sf.orangesignal.ta.dataset.StandardDataset;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * 指定された期間で平均化した売買代金の範囲でフィルターするストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class ValueAverageFilter extends TradingStrategySupport {

	/**
	 * デフォルトコンストラクタです。
	 */
	public ValueAverageFilter() {}

	/**
	 * 直近期間を保持します。
	 */
	private int period = 1;

	/**
	 * 直近期間を返します。
	 * 
	 * @return 直近期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 直近期間を設定します。
	 * 
	 * @param period 直近期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	/**
	 * 上限価格を保持します。
	 */
	private double upper;

	/**
	 * 上限価格を返します。
	 * 
	 * @return 上限価格
	 */
	public double getUpper() { return upper; }

	/**
	 * 上限価格を設定します。
	 * 
	 * @param upper 上限価格
	 */
	public void setUpper(final double upper) { this.upper = upper; }

	/**
	 * 下限価格を保持します。
	 */
	private double lower = 5000000;

	/**
	 * 下限価格を返します。
	 * 
	 * @return 下限価格
	 */
	public double getLower() { return lower; }

	/**
	 * 下限価格を設定します。
	 * 
	 * @param lower 下限価格
	 */
	public void setLower(final double lower) { this.lower = lower; }

	/**
	 * 売買代金平均データを保持します。
	 */
	private Number[] values;

	@Override
	public void prepare() {
		final StandardDataset dataset = getDataset();
		values = sma(sub(dataset.getClose(), dataset.getVolume()), period);
	}

	@Override
	public boolean execute() {
		final Number value = values[getCurrentDataIndex()];
		return (value != null && ((upper > 0 && value.doubleValue() > upper) || (lower > 0 && value.doubleValue() < lower)));
	}

	@Override
	public void close() {
		values = null;
	}

}
