/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.seasar.extension.jta.ExtendedTransaction;
import org.seasar.extension.jta.XAResourceWrapper;
import org.seasar.extension.jta.xa.XidImpl;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.exception.SRollbackException;
import org.seasar.framework.exception.SSystemException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.SLinkedList;

public final class TransactionImpl
implements ExtendedTransaction {
    private static final int VOTE_READONLY = 0;
    private static final int VOTE_COMMIT = 1;
    private static final int VOTE_ROLLBACK = 2;
    private static Logger logger = Logger.getLogger((Class)TransactionImpl.class);
    private Xid xid;
    private int status = 6;
    private List xaResourceWrappers = new ArrayList();
    private List synchronizations = new ArrayList();
    private List interposedSynchronizations = new ArrayList();
    private Map resourceMap = new HashMap();
    private boolean suspended = false;
    private int branchId = 0;

    public void begin() throws NotSupportedException, SystemException {
        this.status = 0;
        this.init();
        if (logger.isDebugEnabled()) {
            logger.log("DSSR0003", new Object[]{this});
        }
    }

    public void suspend() throws SystemException {
        this.assertNotSuspended();
        this.assertActive();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                xarw.end(0x2000000);
                continue;
            }
            catch (XAException ex) {
                throw new SSystemException("ESSR0363", new Object[]{ex}, (Throwable)ex);
            }
        }
        this.suspended = true;
    }

    private void assertNotSuspended() throws IllegalStateException {
        if (this.suspended) {
            throw new SIllegalStateException("ESSR0314", null);
        }
    }

    private void assertActive() throws IllegalStateException {
        switch (this.status) {
            case 0: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    private void throwIllegalStateException() throws IllegalStateException {
        switch (this.status) {
            case 7: {
                throw new SIllegalStateException("ESSR0304", null);
            }
            case 2: {
                throw new SIllegalStateException("ESSR0305", null);
            }
            case 8: {
                throw new SIllegalStateException("ESSR0306", null);
            }
            case 3: {
                throw new SIllegalStateException("ESSR0307", null);
            }
            case 1: {
                throw new SIllegalStateException("ESSR0308", null);
            }
            case 9: {
                throw new SIllegalStateException("ESSR0309", null);
            }
            case 4: {
                throw new SIllegalStateException("ESSR0310", null);
            }
            case 6: {
                throw new SIllegalStateException("ESSR0311", null);
            }
            case 5: {
                throw new SIllegalStateException("ESSR0312", null);
            }
        }
        throw new SIllegalStateException("ESSR0032", new Object[]{String.valueOf(this.status)});
    }

    private int getXAResourceWrapperSize() {
        return this.xaResourceWrappers.size();
    }

    private XAResourceWrapper getXAResourceWrapper(int index) {
        return (XAResourceWrapper)this.xaResourceWrappers.get(index);
    }

    public void resume() throws SystemException {
        this.assertSuspended();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                xarw.start(0x8000000);
                continue;
            }
            catch (XAException ex) {
                throw new SSystemException("ESSR0364", new Object[]{ex}, (Throwable)ex);
            }
        }
        this.suspended = false;
    }

    private void assertSuspended() throws IllegalStateException {
        if (!this.suspended) {
            throw new SIllegalStateException("ESSR0315", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.assertNotSuspended();
            this.assertActive();
            this.beforeCompletion();
            if (this.status == 0) {
                this.endResources(0x4000000);
                if (this.getXAResourceWrapperSize() == 0) {
                    this.status = 3;
                } else if (this.getXAResourceWrapperSize() == 1) {
                    this.commitOnePhase();
                } else {
                    switch (this.prepareResources()) {
                        case 0: {
                            this.status = 3;
                            break;
                        }
                        case 1: {
                            this.commitTwoPhase();
                            break;
                        }
                        case 2: {
                            this.rollbackForVoteOK();
                        }
                    }
                }
                if (this.status == 3 && logger.isDebugEnabled()) {
                    logger.log("DSSR0004", new Object[]{this});
                }
            }
            boolean rolledBack = this.status != 3;
            this.afterCompletion();
            if (rolledBack) {
                throw new SRollbackException("ESSR0303", new Object[]{this.toString()});
            }
        }
        finally {
            this.destroy();
        }
    }

    private void beforeCompletion() {
        int i;
        for (i = 0; i < this.getSynchronizationSize() && this.status == 0; ++i) {
            this.beforeCompletion(this.getSynchronization(i));
        }
        for (i = 0; i < this.getInterposedSynchronizationSize() && this.status == 0; ++i) {
            this.beforeCompletion(this.getInterposedSynchronization(i));
        }
    }

    private void beforeCompletion(Synchronization sync) {
        try {
            sync.beforeCompletion();
        }
        catch (Throwable t) {
            logger.log(t);
            this.status = 1;
            this.endResources(0x20000000);
            this.rollbackResources();
        }
    }

    private void endResources(int flag) {
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                xarw.end(flag);
                continue;
            }
            catch (Throwable t) {
                logger.log(t);
                this.status = 1;
            }
        }
    }

    private void commitOnePhase() {
        this.status = 8;
        XAResourceWrapper xari = this.getXAResourceWrapper(0);
        try {
            xari.commit(true);
            this.status = 3;
        }
        catch (Throwable t) {
            logger.log(t);
            this.status = 5;
        }
    }

    private int prepareResources() {
        XAResourceWrapper xarw;
        int i;
        this.status = 7;
        int vote = 0;
        SLinkedList xarwList = new SLinkedList();
        for (i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            xarw = this.getXAResourceWrapper(i);
            if (!xarw.isCommitTarget()) continue;
            xarwList.addFirst((Object)xarw);
        }
        for (i = 0; i < xarwList.size(); ++i) {
            xarw = (XAResourceWrapper)xarwList.get(i);
            try {
                if (i == xarwList.size() - 1) {
                    xarw.commit(true);
                    xarw.setVoteOk(false);
                    vote = 1;
                    continue;
                }
                if (xarw.prepare() == 0) {
                    vote = 1;
                    continue;
                }
                xarw.setVoteOk(false);
                continue;
            }
            catch (Throwable t) {
                logger.log(t);
                xarw.setVoteOk(false);
                this.status = 1;
                return 2;
            }
        }
        if (this.status == 7) {
            this.status = 2;
        }
        return vote;
    }

    private void commitTwoPhase() {
        this.status = 8;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xarw.isCommitTarget() || !xarw.isVoteOk()) continue;
            try {
                xarw.commit(false);
                continue;
            }
            catch (Throwable t) {
                logger.log(t);
                this.status = 5;
            }
        }
        if (this.status == 8) {
            this.status = 3;
        }
    }

    private void rollbackForVoteOK() {
        this.status = 9;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xarw.isVoteOk()) continue;
            try {
                xarw.rollback();
                continue;
            }
            catch (Throwable t) {
                logger.log(t);
                this.status = 5;
            }
        }
        if (this.status == 9) {
            this.status = 4;
        }
    }

    private void afterCompletion() {
        int i;
        int status = this.status;
        this.status = 6;
        for (i = 0; i < this.getInterposedSynchronizationSize(); ++i) {
            this.afterCompletion(status, this.getInterposedSynchronization(i));
        }
        for (i = 0; i < this.getSynchronizationSize(); ++i) {
            this.afterCompletion(status, this.getSynchronization(i));
        }
    }

    private void afterCompletion(int status, Synchronization sync) {
        try {
            sync.afterCompletion(status);
        }
        catch (Throwable t) {
            logger.log(t);
        }
    }

    private int getSynchronizationSize() {
        return this.synchronizations.size();
    }

    private Synchronization getSynchronization(int index) {
        return (Synchronization)this.synchronizations.get(index);
    }

    private int getInterposedSynchronizationSize() {
        return this.interposedSynchronizations.size();
    }

    private Synchronization getInterposedSynchronization(int index) {
        return (Synchronization)this.interposedSynchronizations.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.assertNotSuspended();
            this.assertActiveOrMarkedRollback();
            this.endResources(0x20000000);
            this.rollbackResources();
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0005", new Object[]{this});
            }
            this.afterCompletion();
        }
        finally {
            this.destroy();
        }
    }

    private void assertActiveOrMarkedRollback() throws IllegalStateException {
        switch (this.status) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    private void rollbackResources() {
        this.status = 9;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                if (!xarw.isCommitTarget()) continue;
                xarw.rollback();
                continue;
            }
            catch (Throwable t) {
                logger.log(t);
                this.status = 5;
            }
        }
        if (this.status == 9) {
            this.status = 4;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActiveOrPreparingOrPrepared();
        this.status = 1;
    }

    private void assertActiveOrPreparingOrPrepared() throws IllegalStateException {
        switch (this.status) {
            case 0: 
            case 2: 
            case 7: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        boolean commitTarget;
        boolean oracled = xaResource.getClass().getName().startsWith("oracle");
        this.assertNotSuspended();
        this.assertActive();
        Xid xid = null;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (xaResource.equals(xarw.getXAResource())) {
                return false;
            }
            if (oracled) continue;
            try {
                if (!xaResource.isSameRM(xarw.getXAResource())) continue;
                xid = xarw.getXid();
                break;
            }
            catch (XAException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
        int flag = xid == null ? 0 : 0x200000;
        boolean bl = commitTarget = xid == null;
        if (xid == null) {
            xid = this.createXidBranch();
        }
        try {
            xaResource.start(xid, flag);
            this.xaResourceWrappers.add(new XAResourceWrapper(xaResource, xid, commitTarget));
            return true;
        }
        catch (XAException ex) {
            IllegalStateException ise = new IllegalStateException(ex.toString());
            ise.initCause(ex);
            throw ise;
        }
    }

    private Xid createXidBranch() {
        return new XidImpl(this.xid, ++this.branchId);
    }

    public boolean delistResource(XAResource xaResource, int flag) throws IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActiveOrMarkedRollback();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xaResource.equals(xarw.getXAResource())) continue;
            try {
                xarw.end(flag);
                return true;
            }
            catch (XAException ex) {
                logger.log((Throwable)ex);
                this.status = 1;
                return false;
            }
        }
        throw new SIllegalStateException("ESSR0313", null);
    }

    public int getStatus() {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActive();
        this.synchronizations.add(sync);
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        this.assertNotSuspended();
        this.assertActive();
        this.interposedSynchronizations.add(sync);
    }

    public void putResource(Object key, Object value) throws IllegalStateException {
        this.assertNotSuspended();
        this.resourceMap.put(key, value);
    }

    public Object getResource(Object key) throws IllegalStateException {
        this.assertNotSuspended();
        return this.resourceMap.get(key);
    }

    public Xid getXid() {
        return this.xid;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    private void init() {
        this.xid = new XidImpl();
    }

    private void destroy() {
        this.status = 6;
        this.xaResourceWrappers.clear();
        this.synchronizations.clear();
        this.interposedSynchronizations.clear();
        this.resourceMap.clear();
        this.suspended = false;
    }

    public String toString() {
        return this.xid.toString();
    }

    public List getSynchronizations() {
        return this.synchronizations;
    }

    public List getInterposedSynchronizations() {
        return this.interposedSynchronizations;
    }
}

