/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.handler.AbstractMapResultSetHandler;
import org.seasar.framework.convention.PersistenceConvention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapListSupportLimitResultSetHandler
extends AbstractMapResultSetHandler {
    protected int limit;

    public MapListSupportLimitResultSetHandler(Class<? extends Map> mapClass, DbmsDialect dialect, PersistenceConvention peristenceConvention, String sql, int limit) {
        super(mapClass, dialect, peristenceConvention, sql);
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) throws IllegalArgumentException {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be greater than 0.");
        }
        this.limit = limit;
    }

    public Object handle(ResultSet rs) throws SQLException {
        PropertyType[] propertyTypes = this.createPropertyTypes(rs.getMetaData());
        ArrayList<Object> list = new ArrayList<Object>(100);
        for (int i = 0; i < this.limit && rs.next(); ++i) {
            Object row = this.createRow(rs, propertyTypes);
            list.add(row);
        }
        return list;
    }
}

