/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.util;

import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopy<S extends AbstractCopy<S>> {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected String[] includePropertyNames = EMPTY_STRING_ARRAY;
    protected String[] excludePropertyNames = EMPTY_STRING_ARRAY;
    protected boolean excludesNull = false;
    protected String prefix;
    protected char beanDelimiter = (char)36;
    protected char mapDelimiter = (char)46;

    public S includes(String ... propertyNames) {
        if (this.excludePropertyNames.length > 0) {
            throw new IllegalArgumentException("Do not specify both includes and excludes.");
        }
        this.includePropertyNames = propertyNames;
        return (S)this;
    }

    public S excludes(String ... propertyNames) {
        if (this.includePropertyNames.length > 0) {
            throw new IllegalArgumentException("Do not specify both includes and excludes.");
        }
        this.excludePropertyNames = propertyNames;
        return (S)this;
    }

    public S excludesNull() {
        this.excludesNull = true;
        return (S)this;
    }

    public S prefix(String prefix) {
        this.prefix = prefix;
        return (S)this;
    }

    public S beanDelimiter(char beanDelimiter) {
        this.beanDelimiter = beanDelimiter;
        return (S)this;
    }

    public S mapDelimiter(char mapDelimiter) {
        this.mapDelimiter = mapDelimiter;
        return (S)this;
    }

    protected boolean isTargetProperty(String name) {
        if (this.includePropertyNames.length > 0) {
            for (String s : this.includePropertyNames) {
                if (!s.equals(name) || this.prefix != null && !name.startsWith(this.prefix)) continue;
                return true;
            }
            return false;
        }
        if (this.excludePropertyNames.length > 0) {
            for (String s : this.excludePropertyNames) {
                if (!s.equals(name)) continue;
                return false;
            }
            return true;
        }
        return this.prefix == null || name.startsWith(this.prefix);
    }

    protected void copyBeanToBean(Object src, Object dest) {
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        int size = srcBeanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(i);
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !this.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = this.trimPrefix(srcPropertyName)) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || (value = srcPropertyDesc.getValue(src)) == null && this.excludesNull) continue;
            destPropertyDesc.setValue(dest, value);
        }
    }

    protected void copyBeanToMap(Object src, Map dest) {
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        int size = srcBeanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Object value;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(i);
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !this.isTargetProperty(srcPropertyName) || (value = srcPropertyDesc.getValue(src)) == null && this.excludesNull) continue;
            String destPropertyName = this.trimPrefix(srcPropertyName.replace(this.beanDelimiter, this.mapDelimiter));
            dest.put(destPropertyName, value);
        }
    }

    protected void copyMapToBean(Map<String, Object> src, Object dest) {
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        for (String srcPropertyName : src.keySet()) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            if (!this.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = this.trimPrefix(srcPropertyName.replace(this.mapDelimiter, this.beanDelimiter))) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || (value = src.get(srcPropertyName)) == null && this.excludesNull) continue;
            destPropertyDesc.setValue(dest, value);
        }
    }

    protected void copyMapToMap(Map<String, Object> src, Map<String, Object> dest) {
        for (String srcPropertyName : src.keySet()) {
            if (!this.isTargetProperty(srcPropertyName)) continue;
            String destPropertyName = this.trimPrefix(srcPropertyName);
            Object value = src.get(srcPropertyName);
            if (value == null && this.excludesNull) continue;
            dest.put(destPropertyName, value);
        }
    }

    protected String trimPrefix(String propertyName) {
        if (this.prefix == null) {
            return propertyName;
        }
        return propertyName.substring(this.prefix.length());
    }
}

