/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.commission;

import jp.sf.orangesignal.trading.commission.CommissionUnit;

public class FixedCommission
extends CommissionUnit {
    private static final long serialVersionUID = 4645452184754354352L;
    private double commission;
    private double step;
    private double adding;
    private double max;

    public FixedCommission() {
    }

    public FixedCommission(double commission) {
        this(0.0, commission, 0.0, 0.0, 0.0);
    }

    public FixedCommission(double base, double commission) {
        this(base, commission, 0.0, 0.0, 0.0);
    }

    public FixedCommission(double base, double commission, double step, double adding) {
        this(base, commission, step, adding, 0.0);
    }

    public FixedCommission(double base, double commission, double step, double adding, double max) {
        super(base);
        this.commission = commission;
        this.step = step;
        this.adding = adding;
        this.max = max;
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double commission) {
        this.commission = commission;
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public double getAdding() {
        return this.adding;
    }

    public void setAdding(double adding) {
        this.adding = adding;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    @Override
    public double calcCommission(double price, int quantity) {
        double result = this.commission;
        if (this.step != 0.0) {
            result += this.adding * Math.floor((price * (double)quantity - this.getBase()) / this.step);
            if (this.max != 0.0 && result > this.max) {
                result = this.max;
            }
        }
        return result;
    }
}

