/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.stats;

import java.io.Serializable;
import java.util.LinkedList;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.stats.Trade;

public abstract class AbstractStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LinkedList<Trade> tradeList = new LinkedList();
    protected double initialCapital;
    protected double endingCapital;
    protected int count;
    protected int maxConsecutiveCount;
    protected int hold;
    protected int maxHold;
    protected double grossSales;
    protected double commission;
    protected double slippage;
    protected double netProfit;
    protected double maxGrossProfit;
    protected double maxGrossLoss;
    protected double maxDrawdown;

    protected AbstractStats() {
    }

    public AbstractStats(LinkedList<Position> positions, double initialCapital, boolean discard) {
        this.statistics(positions, initialCapital, discard);
    }

    protected void statistics(LinkedList<Position> positions, double initialCapital, boolean discard) {
        double equity;
        double maxEquity = equity = initialCapital;
        int consecutiveCount = 0;
        for (Position p : positions) {
            if (!this.isStatistics(p)) {
                consecutiveCount = 0;
                continue;
            }
            ++this.count;
            this.maxConsecutiveCount = Math.max(this.maxConsecutiveCount, ++consecutiveCount);
            int hold = p.getHold();
            this.hold += hold;
            this.maxHold = Math.max(this.maxHold, hold);
            this.grossSales += p.getGrossSales();
            this.commission += p.getCommission();
            this.slippage += p.getSlippage();
            double netProfit = p.getNetProfit();
            this.netProfit += netProfit;
            this.maxGrossProfit = Math.max(this.maxGrossProfit, netProfit);
            this.maxGrossLoss = Math.min(this.maxGrossLoss, netProfit);
            Trade trade = new Trade(p);
            trade.cumNetProfit = this.netProfit;
            trade.equity = equity += netProfit;
            maxEquity = Math.max(maxEquity, equity);
            trade.drawdown = equity - maxEquity;
            this.maxDrawdown = Math.min(this.maxDrawdown, trade.drawdown);
            trade.maxEquity = maxEquity;
            trade.maxDrawdown = this.maxDrawdown;
            this.tradeList.add(trade);
        }
        this.initialCapital = initialCapital;
        double d = this.endingCapital = this.tradeList.isEmpty() ? initialCapital : this.tradeList.getLast().equity;
        if (discard) {
            this.tradeList.clear();
            this.tradeList = null;
        }
    }

    protected abstract boolean isStatistics(Position var1);

    public LinkedList<Trade> getTradeList() {
        return this.tradeList;
    }

    @Deprecated
    public double getBuyAndHoldNetProfit() {
        if (this.tradeList == null || this.tradeList.isEmpty()) {
            return 0.0;
        }
        Trade first = this.tradeList.getFirst();
        Trade last = this.tradeList.getLast();
        double profit = last.getExitAmount() - first.getEntryAmount();
        double commission = first.getEntryCommission() + last.getExitCommission();
        double slippage = first.getEntrySlippage() + last.getExitSlippage();
        return profit - (commission + slippage);
    }

    public double getInitialCapital() {
        return this.initialCapital;
    }

    public double getEndingCapital() {
        return this.endingCapital;
    }

    public double getPercent(double amount) {
        if (amount == 0.0 || this.initialCapital == 0.0) {
            return 0.0;
        }
        return amount / this.initialCapital;
    }

    public int getCount() {
        return this.count;
    }

    public double getAverage(double value) {
        if (value == 0.0 || this.count == 0) {
            return 0.0;
        }
        return value / (double)this.count;
    }

    public int getMaxConsecutiveCount() {
        return this.maxConsecutiveCount;
    }

    public int getHold() {
        return this.hold;
    }

    public int getMaxHold() {
        return this.maxHold;
    }

    public double getAverageHold() {
        return this.getAverage(this.hold);
    }

    public double getGrossSales() {
        return this.grossSales;
    }

    public double getSharpeRatio() {
        double sum = this.initialCapital + this.grossSales;
        if (sum == 0.0 || this.initialCapital == 0.0) {
            return 0.0;
        }
        return sum / this.initialCapital;
    }

    public double getCommission() {
        return this.commission;
    }

    public double getPercentCommission() {
        return this.getPercent(this.getCommission());
    }

    public double getSlippage() {
        return this.slippage;
    }

    public double getNetProfit() {
        return this.netProfit;
    }

    public double getPercentNetProfit() {
        return this.getPercent(this.netProfit);
    }

    public double getAverageNetProfit() {
        return this.getAverage(this.netProfit);
    }

    public double getPercentAverageNetProfit() {
        return this.getPercent(this.getAverageNetProfit());
    }

    public double getMaxGrossProfit() {
        return this.maxGrossProfit;
    }

    public double getPercentMaxGrossProfit() {
        return this.getPercent(this.maxGrossProfit);
    }

    public double getMaxGrossLoss() {
        return this.maxGrossLoss;
    }

    public double getPercentMaxGrossLoss() {
        return this.getPercent(this.maxGrossLoss);
    }

    public double getMaxDrawdown() {
        return this.maxDrawdown;
    }

    public double getPercentMaxDrawdown() {
        return this.getPercent(this.maxDrawdown);
    }
}

