/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.strategy.stop;

import java.util.LinkedList;
import jp.sf.orangesignal.ta.PercentageScale;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.PositionType;
import jp.sf.orangesignal.trading.order.OrderTiming;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

public class ProfitTarget
extends TradingStrategySupport {
    private double profit;
    private PercentageScale scale;

    public double getProfit() {
        return this.profit;
    }

    public void setProfit(double profit) {
        this.profit = profit;
    }

    public PercentageScale getScale() {
        return this.scale;
    }

    public void setScale(PercentageScale scale) {
        this.scale = scale;
    }

    @Override
    public boolean execute() {
        LinkedList<Position> positions = this.getCurrentPositions();
        for (Position p : positions) {
            double profit;
            double d = profit = this.scale == null ? this.profit : Math.ceil(p.getEntryPrice() * (this.profit / this.scale.scale()));
            if (p.getType() == PositionType.LONG) {
                this.sell(this.getStrategyName(), OrderTiming.NEXT_LIMIT, p.getEntryPrice() + profit, p.getEntryLabel());
                continue;
            }
            if (p.getType() != PositionType.SHORT) continue;
            this.buyToCover(this.getStrategyName(), OrderTiming.NEXT_LIMIT, p.getEntryPrice() - profit, p.getEntryLabel());
        }
        return false;
    }
}

