/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.handlers.CsvValueConverter;
import jp.sf.orangesignal.csv.handlers.SimpleCsvValueConverter;

public abstract class BeanListHandlerSupport<T>
implements CsvListHandler<T> {
    private Class<T> type;
    private CsvValueConverter converter = new SimpleCsvValueConverter();

    protected BeanListHandlerSupport(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        this.type = type;
    }

    public BeanListHandlerSupport<T> converter(CsvValueConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("CsvValueConverter must not be null");
        }
        this.converter = converter;
        return this;
    }

    public CsvValueConverter getConverter() {
        return this.converter;
    }

    public Class<T> getType() {
        return this.type;
    }

    protected T createBean() throws IOException {
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected static Field getField(Class<?> type, String name) throws IOException {
        try {
            return type.getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected static void setFieldValue(Object obj, Field f, Object value) throws IOException {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        try {
            f.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected static Object getFieldValue(Object obj, Field f) throws IOException {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        try {
            return f.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

