/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.manager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipOutputStream;
import jp.gr.java_conf.dangan.util.lha.LhaOutputStream;
import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.handlers.BeanListHandler;
import jp.sf.orangesignal.csv.manager.CsvSaver;

public class CsvBeanSaver<T>
implements CsvSaver<T> {
    private CsvConfig cfg;
    private List<T> beans;
    private BeanListHandler<T> handler;

    public CsvBeanSaver(CsvConfig cfg, List<T> beans, Class<T> beanClass) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        this.cfg = cfg;
        this.beans = beans;
        this.handler = new BeanListHandler<T>(beanClass);
    }

    public CsvBeanSaver<T> includes(String ... names) {
        this.handler.includes(names);
        return this;
    }

    public CsvBeanSaver<T> excludes(String ... names) {
        this.handler.excludes(names);
        return this;
    }

    @Override
    public void to(Writer writer) throws IOException {
        Csv.save(this.beans, writer, this.cfg, this.handler);
    }

    @Override
    public void to(OutputStream out, String encoding) throws IOException {
        Csv.save(this.beans, out, encoding, this.cfg, this.handler);
    }

    @Override
    public void to(OutputStream out) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.handler);
    }

    @Override
    public void to(File file, String encoding) throws IOException {
        Csv.save(this.beans, file, encoding, this.cfg, this.handler);
    }

    @Override
    public void to(File file) throws IOException {
        Csv.save(this.beans, file, this.cfg, this.handler);
    }

    @Override
    public void to(LhaOutputStream out, String entryName) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.handler, entryName);
    }

    @Override
    public void to(ZipOutputStream out, String entryName) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.handler, entryName);
    }
}

