/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.manager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipOutputStream;
import jp.gr.java_conf.dangan.util.lha.LhaOutputStream;
import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.handlers.CsvEntityListHandler;
import jp.sf.orangesignal.csv.manager.CsvSaver;

public class CsvEntitySaver<T>
implements CsvSaver<T> {
    private CsvConfig cfg;
    private List<T> entities;
    private CsvEntityListHandler<T> handler;

    public CsvEntitySaver(CsvConfig cfg, List<T> entities, Class<T> entityClass) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        this.cfg = cfg;
        this.entities = entities;
        this.handler = new CsvEntityListHandler<T>(entityClass);
    }

    @Override
    public void to(Writer writer) throws IOException {
        Csv.save(this.entities, writer, this.cfg, this.handler);
    }

    @Override
    public void to(OutputStream out, String encoding) throws IOException {
        Csv.save(this.entities, out, encoding, this.cfg, this.handler);
    }

    @Override
    public void to(OutputStream out) throws IOException {
        Csv.save(this.entities, out, this.cfg, this.handler);
    }

    @Override
    public void to(File file, String encoding) throws IOException {
        Csv.save(this.entities, file, encoding, this.cfg, this.handler);
    }

    @Override
    public void to(File file) throws IOException {
        Csv.save(this.entities, file, this.cfg, this.handler);
    }

    @Override
    public void to(LhaOutputStream out, String entryName) throws IOException {
        Csv.save(this.entities, out, this.cfg, this.handler, entryName);
    }

    @Override
    public void to(ZipOutputStream out, String entryName) throws IOException {
        Csv.save(this.entities, out, this.cfg, this.handler, entryName);
    }
}

