/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.lang.reflect;

import java.math.BigInteger;

public class Type {
    private Type() {
    }

    public static boolean matchFullAll(Class[] types, Object[] args) {
        boolean match = types.length == args.length;
        int i = 0;
        while (i < types.length) {
            match = match && Type.matchFull(types[i], args[i]);
            ++i;
        }
        return match;
    }

    public static boolean matchRestrictAll(Class[] types, Object[] args) {
        boolean match = types.length == args.length;
        int i = 0;
        while (i < types.length) {
            match = match && Type.matchRestrict(types[i], args[i]);
            ++i;
        }
        return match;
    }

    public static boolean matchAll(Class[] types, Object[] args) {
        boolean match = types.length == args.length;
        int i = 0;
        while (i < types.length) {
            match = match && Type.match(types[i], args[i]);
            ++i;
        }
        return match;
    }

    public static boolean matchFull(Class type, Object obj) {
        if (type.isInstance(obj)) {
            return true;
        }
        if (!type.isPrimitive() && obj == null) {
            return true;
        }
        if (type.equals(Boolean.TYPE) && obj instanceof Boolean) {
            return true;
        }
        if (type.equals(Byte.TYPE) && obj instanceof Byte) {
            return true;
        }
        if (type.equals(Short.TYPE) && obj instanceof Short) {
            return true;
        }
        if (type.equals(Character.TYPE) && obj instanceof Character) {
            return true;
        }
        if (type.equals(Integer.TYPE) && obj instanceof Integer) {
            return true;
        }
        if (type.equals(Long.TYPE) && obj instanceof Long) {
            return true;
        }
        if (type.equals(Float.TYPE) && obj instanceof Float) {
            return true;
        }
        return type.equals(Double.TYPE) && obj instanceof Double;
    }

    public static boolean matchRestrict(Class type, Object obj) {
        if (Type.matchFull(type, obj)) {
            return true;
        }
        return !(!type.equals(Byte.TYPE) && !type.equals(Short.TYPE) && !type.equals(Integer.TYPE) && !type.equals(Long.TYPE) && !type.equals(Float.TYPE) && !type.equals(Double.TYPE) || !(obj instanceof Byte) && !(obj instanceof Short) && !(obj instanceof Integer) && !(obj instanceof Long) && !(obj instanceof Float) && !(obj instanceof Double));
    }

    public static boolean match(Class type, Object obj) {
        String str;
        String string = str = obj == null ? null : obj.toString();
        if (Type.matchRestrict(type, obj)) {
            return true;
        }
        if (type.equals(String.class)) {
            return true;
        }
        if (!type.isPrimitive() && "NULL".equalsIgnoreCase(str)) {
            return true;
        }
        if ((type.equals(Byte.class) || type.equals(Byte.TYPE) || type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE)) && (obj instanceof Number || obj != null && Type.isLongString(obj.toString()) || obj != null && Type.isDoubleString(obj.toString()))) {
            return true;
        }
        if ((type.equals(Boolean.TYPE) || type.equals(Boolean.class)) && ("TRUE".equalsIgnoreCase(str) || "FALSE".equalsIgnoreCase(str))) {
            return true;
        }
        return !(!type.equals(Character.class) && !type.equals(Character.TYPE) || !(obj instanceof String) || str.length() != 1 && !Type.isUnicodeEscape(str));
    }

    public static Object[] parseAll(Class[] types, Object[] args) {
        if (types.length == args.length) {
            Object[] objs = new Object[args.length];
            int i = 0;
            while (i < args.length) {
                objs[i] = Type.parse(types[i], args[i]);
                ++i;
            }
            return objs;
        }
        throw new IllegalArgumentException();
    }

    public static Object parse(Class type, Object obj) {
        String str;
        String string = str = obj == null ? null : obj.toString();
        if (type.isInstance(obj)) {
            return obj;
        }
        if (!(type.isPrimitive() || type.equals(String.class) || obj != null && !"NULL".equalsIgnoreCase(str))) {
            return null;
        }
        if (type.equals(String.class)) {
            return str;
        }
        if ((type.equals(Byte.class) || type.equals(Byte.TYPE) || type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE)) && (obj instanceof Number || obj != null && Type.isLongString(str) || obj != null && Type.isDoubleString(str))) {
            Number num = null;
            if (obj instanceof Number) {
                num = (Number)obj;
            } else {
                try {
                    num = Type.isLongString(str) ? (Number)new Long(Long.parseLong(str)) : (Number)new Double(str);
                }
                catch (NumberFormatException exception) {
                    num = Type.parseHexadecimal(str.substring(2));
                }
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return new Byte(num.byteValue());
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return new Short(num.shortValue());
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return new Integer(num.intValue());
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return new Long(num.longValue());
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return new Float(num.floatValue());
            }
            return new Double(num.doubleValue());
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            if ("TRUE".equalsIgnoreCase(str)) {
                return new Boolean(true);
            }
            if ("FALSE".equalsIgnoreCase(str)) {
                return new Boolean(false);
            }
        } else if ((type.equals(Character.class) || type.equals(Character.TYPE)) && obj != null) {
            if (str.length() == 1) {
                return new Character(str.charAt(0));
            }
            if (Type.isUnicodeEscape(str)) {
                return new Character((char)Type.parseHexadecimal(str.substring(2)).intValue());
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean isUnicodeEscape(String str) {
        return str.length() == 6 && str.startsWith("\\u") && Type.isHexadecimal(str.substring(2));
    }

    private static boolean isLongString(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            if (str.startsWith("0x") && Type.isHexadecimal(str.substring(2))) {
                BigInteger val = Type.parseHexadecimal(str.substring(2));
                BigInteger zero = new BigInteger("0");
                BigInteger limit = new BigInteger("FFFFFFFFFFFFFFFF", 16);
                return zero.compareTo(val) <= 0 && val.compareTo(limit) <= 0;
            }
            return false;
        }
    }

    private static boolean isDoubleString(String str) {
        try {
            Double num = Double.valueOf(str);
            return !num.isInfinite() || str.equals("Infinity") || str.equals("-Infinity");
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isHexadecimal(String str) {
        String hexadecimal = "0123456789ABCDEF";
        if ((str = str.toUpperCase()).length() > 0) {
            int i = 0;
            while (i < str.length()) {
                if ("0123456789ABCDEF".indexOf(str.charAt(i)) < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static BigInteger parseHexadecimal(String str) {
        return new BigInteger(str, 16);
    }
}

