/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.entryfilters;

import java.util.Collection;
import java.util.zip.ZipEntry;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.sf.orangesignal.csv.LhaEntryFilter;
import jp.sf.orangesignal.csv.ZipEntryFilter;

public class PrefixEntryNameFilter
implements ZipEntryFilter,
LhaEntryFilter {
    private String[] prefixes;
    private boolean ignoreCase;

    public PrefixEntryNameFilter(String prefix) {
        this(new String[]{prefix}, false);
    }

    public PrefixEntryNameFilter(String prefix, boolean ignoreCase) {
        this(new String[]{prefix}, ignoreCase);
    }

    public PrefixEntryNameFilter(String[] prefixes) {
        this(prefixes, false);
    }

    public PrefixEntryNameFilter(String[] prefixes, boolean ignoreCase) {
        if (prefixes == null) {
            throw new IllegalArgumentException("Prefixes must not be null");
        }
        this.prefixes = prefixes;
        this.ignoreCase = ignoreCase;
    }

    public PrefixEntryNameFilter(Collection<String> prefixes) {
        this(prefixes, false);
    }

    public PrefixEntryNameFilter(Collection<String> prefixes, boolean ignoreCase) {
        if (prefixes == null) {
            throw new IllegalArgumentException("Prefixes must not be null");
        }
        this.prefixes = prefixes.toArray(new String[0]);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accept(ZipEntry entry) {
        return this.accept(entry.getName());
    }

    @Override
    public boolean accept(LhaHeader entry) {
        return this.accept(entry.getPath());
    }

    private boolean accept(String path) {
        for (String prefix : this.prefixes) {
            boolean b = path.regionMatches(this.ignoreCase, 0, prefix, 0, prefix.length());
            if (!b) continue;
            return true;
        }
        return false;
    }
}

