/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 *
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 *
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

/**
 * Java プログラム要素から区切り文字形式データを使用するための注釈を定義します。
 *
 * <pre>
 * 項目名で項目を指定する場合の例:
 * &#064;CsvEntity(header = true)
 * public class Price {
 *
 *     &#064;CsvColumn(name = "コード")
 *     String code;
 *
 *     &#064;CsvColumn(name = "市場")
 *     String market;
 *
 *     &#064;CsvColumn(name = "日付")
 *     Date date;
 *
 *     &#064;CsvColumn(name = "始値")
 *     Number open;
 *
 *     &#064;CsvColumn(name = "高値")
 *     Number high;
 *
 *     &#064;CsvColumn(name = "安値")
 *     Number low;
 *
 *     &#064;CsvColumn(name = "終値")
 *     Number close;
 *
 *     &#064;CsvColumn(name = "出来高")
 *     Number volume;
 *
 * }
 * </pre>
 * <pre>
 * 項目位置で項目を指定する場合の例:
 * &#064;CsvEntity(header = false)
 * public class Price {
 *
 *     &#064;CsvColumn(position = 0)
 *     String code;
 *
 *     &#064;CsvColumn(position = 1)
 *     String market;
 *
 *     &#064;CsvColumn(position = 2)
 *     Date date;
 *
 *     &#064;CsvColumn(position = 3)
 *     Number open;
 *
 *     &#064;CsvColumn(position = 4)
 *     Number high;
 *
 *     &#064;CsvColumn(position = 5)
 *     Number low;
 *
 *     &#064;CsvColumn(position = 6)
 *     Number close;
 *
 *     &#064;CsvColumn(position = 7)
 *     Number volume;
 *
 * }
 * </pre>
 */
package jp.sf.orangesignal.csv.annotation;

