/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 *
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 *
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.csv.manager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipOutputStream;

import jp.gr.java_conf.dangan.util.lha.LhaOutputStream;
import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.annotation.CsvEntity;
import jp.sf.orangesignal.csv.handlers.CsvEntityListHandler;

/**
 * 区切り文字形式データ注釈要素 {@link CsvEntity} で注釈付けされた Java プログラム要素のリストと区切り文字形式データの統合出力インタフェースの実装クラスを提供します。
 *
 * @author 杉澤 浩二
 */
public class CsvEntitySaver<T> implements CsvSaver<T> {

	/**
	 * 区切り文字形式情報を保持します。
	 */
	private CsvConfig cfg;

	/**
	 * Java プログラム要素のリストを保持します。
	 */
	private List<T> entities;

	/**
	 * データアクセスハンドラを保持します。
	 */
	private CsvEntityListHandler<T> handler;

	/**
	 * コンストラクタです。
	 * 
	 * @param cfg 区切り文字形式情報
	 * @param entities Java プログラム要素のリスト
	 * @param entityClass Java プログラム要素の型
	 * @throws IllegalArgumentException パラメータが不正な場合
	 */
	public CsvEntitySaver(final CsvConfig cfg, final List<T> entities, final Class<T> entityClass) {
		if (cfg == null) {
			throw new IllegalArgumentException("CsvConfig must not be null");
		}
		this.cfg = cfg;
		this.entities = entities;
		this.handler = new CsvEntityListHandler<T>(entityClass);
	}

	@Override
	public void to(final Writer writer) throws IOException {
		Csv.save(entities, writer, cfg, handler);
	}

	@Override
	public void to(final OutputStream out, final String encoding) throws IOException {
		Csv.save(entities, out, encoding, cfg, handler);
	}

	@Override
	public void to(final OutputStream out) throws IOException {
		Csv.save(entities, out, cfg, handler);
	}

	@Override
	public void to(final File file, final String encoding) throws IOException {
		Csv.save(entities, file, encoding, cfg, handler);
	}

	@Override
	public void to(final File file) throws IOException {
		Csv.save(entities, file, cfg, handler);
	}

	@Override
	public void to(final LhaOutputStream out, final String entryName) throws IOException {
		Csv.save(entities, out, cfg, handler, entryName);
	}

	@Override
	public void to(final ZipOutputStream out, final String entryName) throws IOException {
		Csv.save(entities, out, cfg, handler, entryName);
	}

}
