/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.annotation.CsvColumn;
import jp.sf.orangesignal.csv.annotation.CsvColumns;
import jp.sf.orangesignal.csv.annotation.CsvEntity;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class CsvEntityListHandler<T>
extends BeanListHandlerSupport<T> {
    public CsvEntityListHandler(Class<T> entityClass) {
        super(entityClass);
        if (entityClass.getAnnotation(CsvEntity.class) == null) {
            throw new IllegalArgumentException(String.format("No CsvEntity is available %s", entityClass.getName()));
        }
    }

    private static Format createFormat(CsvColumn column, Field f) {
        Locale locale;
        String pattern = column.format();
        if (pattern.isEmpty()) {
            return null;
        }
        Locale locale2 = locale = column.language().isEmpty() ? Locale.getDefault() : new Locale(column.language(), column.country());
        if (Date.class.isAssignableFrom(f.getType())) {
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            if (!column.timezone().isEmpty()) {
                format.setTimeZone(TimeZone.getTimeZone(column.timezone()));
            }
            return format;
        }
        DecimalFormat format = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale));
        if (!column.currency().isEmpty()) {
            format.setCurrency(Currency.getInstance(column.currency()));
        }
        return format;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        List<String> names = this.getType().getAnnotation(CsvEntity.class).header() ? reader.readValues() : CsvEntityListHandler.getColumnNames(this.getType());
        Field[] fields = this.getType().getDeclaredFields();
        this.prepare(names, fields);
        ArrayList results = new ArrayList();
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.getLimit() <= 0 || results.size() < this.getLimit())) {
            if (offset < this.getOffset()) {
                ++offset;
                continue;
            }
            Object obj = this.createBean();
            for (Field f : fields) {
                int pos;
                CsvColumn column;
                Object o = null;
                CsvColumns columns = f.getAnnotation(CsvColumns.class);
                if (columns != null) {
                    StringBuilder sb = new StringBuilder();
                    for (CsvColumn column2 : columns.value()) {
                        String s;
                        int pos2 = CsvEntityListHandler.getPosition(column2, f, names);
                        if (pos2 == -1 || (s = values.get(pos2)) == null) continue;
                        sb.append(s);
                    }
                    o = this.stringToObject(f, sb.toString());
                }
                if ((column = f.getAnnotation(CsvColumn.class)) != null && (pos = CsvEntityListHandler.getPosition(column, f, names)) != -1) {
                    o = this.stringToObject(f, values.get(pos));
                }
                if (o == null) continue;
                CsvEntityListHandler.setFieldValue(obj, f, o);
            }
            results.add(obj);
        }
        return results;
    }

    @Override
    public void save(List<T> entities, CsvWriter writer) throws IOException {
        if (entities == null) {
            throw new IllegalArgumentException("CsvEntities must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        List<String> names = CsvEntityListHandler.getColumnNames(this.getType());
        if (this.getType().getAnnotation(CsvEntity.class).header()) {
            writer.writeValues(names);
        }
        this.prepare(names, this.getType().getDeclaredFields());
        int columnCount = names.size();
        for (T entity : entities) {
            if (entity == null || entity.getClass().getAnnotation(CsvEntity.class) == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            for (Field f : entity.getClass().getDeclaredFields()) {
                CsvColumn column;
                CsvColumns columns = f.getAnnotation(CsvColumns.class);
                if (columns != null) {
                    for (CsvColumn column2 : columns.value()) {
                        int pos = column2.position();
                        if (pos < 0) {
                            pos = names.indexOf(CsvEntityListHandler.defaultIfEmpty(column2.name(), f.getName()));
                        }
                        if (pos == -1) {
                            throw new IOException(String.format("Invalid CsvColumn field %s", f.getName()));
                        }
                        values[pos] = this.objectToString(pos, CsvEntityListHandler.getFieldValue(entity, f));
                    }
                }
                if ((column = f.getAnnotation(CsvColumn.class)) == null) continue;
                int pos = column.position();
                if (pos < 0) {
                    pos = names.indexOf(CsvEntityListHandler.defaultIfEmpty(column.name(), f.getName()));
                }
                if (pos == -1) {
                    throw new IOException(String.format("Invalid CsvColumn field %s", f.getName()));
                }
                values[pos] = this.objectToString(pos, CsvEntityListHandler.getFieldValue(entity, f));
            }
            writer.writeValues(Arrays.asList(values));
        }
    }

    private void prepare(List<String> names, Field[] fields) {
        super.valueParserMapping(new HashMap<String, Format>(0));
        super.valueFormatterMapping(new HashMap<Object, Format>(0));
        for (Field f : fields) {
            Format format;
            CsvColumn column;
            CsvColumns columns = f.getAnnotation(CsvColumns.class);
            if (columns != null) {
                for (CsvColumn column2 : columns.value()) {
                    Format format2 = CsvEntityListHandler.createFormat(column2, f);
                    if (format2 == null) continue;
                    this.setValueParser(f.getName(), format2);
                    this.setValueFormatter(CsvEntityListHandler.getPosition(column2, f, names), format2);
                }
            }
            if ((column = f.getAnnotation(CsvColumn.class)) == null || (format = CsvEntityListHandler.createFormat(column, f)) == null) continue;
            this.setValueParser(f.getName(), format);
            this.setValueFormatter(CsvEntityListHandler.getPosition(column, f, names), format);
        }
    }

    private static List<String> getColumnNames(Class<?> entityClass) {
        TreeMap<Integer, String> positionMap = new TreeMap<Integer, String>();
        ArrayList<String> adding = new ArrayList<String>();
        for (Field f : entityClass.getDeclaredFields()) {
            CsvColumn column;
            CsvColumns columns = f.getAnnotation(CsvColumns.class);
            if (columns != null) {
                for (CsvColumn column2 : columns.value()) {
                    int pos = column2.position();
                    String name = CsvEntityListHandler.defaultIfEmpty(column2.name(), f.getName());
                    if (pos >= 0) {
                        if (positionMap.containsKey(pos)) continue;
                        positionMap.put(pos, name);
                        continue;
                    }
                    adding.add(name);
                }
            }
            if ((column = f.getAnnotation(CsvColumn.class)) == null) continue;
            int pos = column.position();
            String name = CsvEntityListHandler.defaultIfEmpty(column.name(), f.getName());
            if (pos >= 0) {
                if (positionMap.containsKey(pos)) continue;
                positionMap.put(pos, name);
                continue;
            }
            adding.add(name);
        }
        int max = positionMap.size() > 0 ? (Integer)positionMap.lastKey() + 1 : 0;
        String[] names = new String[max];
        for (Map.Entry entry : positionMap.entrySet()) {
            names[((Integer)entry.getKey()).intValue()] = (String)entry.getValue();
        }
        ArrayList<String> results = new ArrayList<String>(Arrays.asList(names));
        if (adding.size() > 0) {
            results.addAll(adding);
        }
        return results;
    }

    private static int getPosition(CsvColumn column, Field f, List<String> names) {
        int pos = column.position();
        if (pos < 0 && names != null) {
            pos = names.indexOf(CsvEntityListHandler.defaultIfEmpty(column.name(), f.getName()));
        }
        if (pos == -1) {
            throw new IllegalStateException(String.format("Invalid CsvColumn field %s", f.getName()));
        }
        return pos;
    }

    private static String defaultIfEmpty(String str, String defaultStr) {
        return str == null || str.isEmpty() ? defaultStr : str;
    }
}

