/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.entryfilters;

import java.util.Collection;
import java.util.zip.ZipEntry;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.sf.orangesignal.csv.entryfilters.AbstractEntryFilter;

public class EntryNameFilter
extends AbstractEntryFilter {
    private static final long serialVersionUID = -147779242205375587L;
    private String[] names;
    private boolean ignoreCase;

    public EntryNameFilter(String name) {
        this(new String[]{name}, false);
    }

    public EntryNameFilter(String name, boolean ignoreCase) {
        this(new String[]{name}, ignoreCase);
    }

    public EntryNameFilter(String[] names) {
        this(names, false);
    }

    public EntryNameFilter(String[] names, boolean ignoreCase) {
        if (names == null) {
            throw new IllegalArgumentException("Names must not be null");
        }
        this.names = names;
        this.ignoreCase = ignoreCase;
    }

    public EntryNameFilter(Collection<String> names) {
        this(names, false);
    }

    public EntryNameFilter(Collection<String> names, boolean ignoreCase) {
        if (names == null) {
            throw new IllegalArgumentException("Names must not be null");
        }
        this.names = names.toArray(new String[0]);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accept(ZipEntry entry) {
        return this.accept(entry.getName());
    }

    @Override
    public boolean accept(LhaHeader entry) {
        return this.accept(entry.getPath());
    }

    private boolean accept(String path) {
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b;
            String name = stringArray[n2];
            boolean bl = b = this.ignoreCase ? path.equalsIgnoreCase(name) : path.equals(name);
            if (b) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append('(');
        if (this.names != null) {
            int length = this.names.length;
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.names[i]);
                ++i;
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

