/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data.model;

import java.io.Serializable;
import java.util.Date;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.annotation.AnnotationParser;
import jp.sf.orangesignal.ta.data.annotation.DateItem;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.util.Assert;

@NumberCompressorType(value=CompressType.SUM)
public class PriceDataset
implements Serializable {
    private static final long serialVersionUID = 3074771444092709164L;
    @DateItem
    protected Date[] date;
    @NumberItem
    @NumberCompressorType(value=CompressType.FIRST)
    protected Number[] open;
    @NumberItem
    @NumberCompressorType(value=CompressType.HIGHEST)
    protected Number[] high;
    @NumberItem
    @NumberCompressorType(value=CompressType.LOWEST)
    protected Number[] low;
    @NumberItem
    @NumberCompressorType(value=CompressType.LAST)
    protected Number[] close;
    @NumberItem
    @NumberCompressorType(value=CompressType.SUM)
    protected Number[] volume;

    public static PriceDataset newInstance(Price[] prices) {
        Assert.notEmpty(prices, "Prices must not be empty");
        return AnnotationParser.parse(prices).build(PriceDataset.class).execute();
    }

    public Date[] getDate() {
        return this.date;
    }

    public void setDate(Date[] date) {
        this.date = date;
    }

    public Number[] getOpen() {
        return this.open;
    }

    public void setOpen(Number[] open) {
        this.open = open;
    }

    public Number[] getHigh() {
        return this.high;
    }

    public void setHigh(Number[] high) {
        this.high = high;
    }

    public Number[] getLow() {
        return this.low;
    }

    public void setLow(Number[] low) {
        this.low = low;
    }

    public Number[] getClose() {
        return this.close;
    }

    public void setClose(Number[] close) {
        this.close = close;
    }

    public Number[] getVolume() {
        return this.volume;
    }

    public void setVolume(Number[] volume) {
        this.volume = volume;
    }
}

