/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

import jp.sf.orangesignal.ta.util.Assert;

/**
 * ローソク足情報生成時に使用されるローソク足生成設定情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public final class CandlestickGeneratorSetting {

	/**
	 * ローソク足基準値の元となるローソク足範囲の種類を表す列挙型を提供します。
	 */
	public enum Range {

		/**
		 * ローソク
		 */
		CANDLE,

		/**
		 * 実体
		 */
		BODY,

		/**
		 * 影(ヒゲ)
		 */
		SHADOW;

	}

	/**
	 * ローソク足範囲の種類を保持します。
	 */
	public final Range range;

	/**
	 * 係数を保持します。
	 */
	public final double factor;

	/**
	 * コンストラクタです。
	 * 
	 * @param range ローソク足範囲の種類
	 * @param factor 係数
	 * @throws IllegalArgumentException ローソク足範囲の種類に <code>null</code> が指定された場合。または係数に <code>0</code> 未満の値が指定された場合
	 */
	public CandlestickGeneratorSetting(final Range range, final double factor) throws NullPointerException, IllegalArgumentException {
		Assert.notNull(range, "Range must not be null");
		Assert.isTrue(factor >= 0D, "factor < 0");
		this.range = range;
		this.factor = factor;
	}

}
