/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

/**
 * ローソク足情報生成設定情報の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum CandlestickGeneratorSettingType {

	/**
	 * 胴体が長い
	 */
	LONG_BODY,

	/**
	 * 胴体が同時
	 */
	DOJI,

	/**
	 * 影(ヒゲ)が長い
	 */
	LONG_SHADOW,

	/**
	 * 影(ヒゲ)が無い(極短含む)
	 */
	NO_SHADOW,

	/**
	 * 同距離
	 */
	SAME,

	/**
	 * 近距離
	 */
	NEAR,

	/**
	 * 遠距離
	 */
	FAR;

}
