/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

/**
 * ローソク足情報生成時に使用されるローソク足生成設定群情報のインターフェースです。
 * 
 * @author 杉澤 浩二
 */
public interface CandlestickGeneratorSettings {

	/**
	 * 指定された種類のローソク足情報生成設定情報を返します。<p>
	 * 実装はパラメータで指定された {@link CandlestickGeneratorSettingType} の値により、
	 * 適切なローソク足情報生成設定情報を返す必要があります。
	 * 
	 * @param type ローソク足情報生成設定情報の種類
	 * @return ローソク足生成設定情報
	 */
	public CandlestickGeneratorSetting getSetting(final CandlestickGeneratorSettingType type);

	/**
	 * ローソク足の長さ基準期間を返します。<p>
	 * 実装は必ず正の値を返す必要があります。
	 * 
	 * @return ローソク足の長さ基準期間
	 */
	public int getLengthPeriod();

	/**
	 * ローソク足の距離基準期間を返します。<p>
	 * 実装は必ず正の値を返す必要があります。
	 * 
	 * @return ローソク足の距離基準期間
	 */
	public int getDistancePeriod();

}