/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.util;

/**
 * 数値変換に関するユーティリティクラスを提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.2
 */
public abstract class NumberUtils {

	/**
	 * 指定された文字列を整数へ変換して返します。
	 * 指定された文字列が整数でない場合は、<code>0</ode> を返します。
	 * 
	 * @param str 文字列
	 * @return 変換された整数。または <code>0</ode>
	 */
	public static int toInt(String str) {
		return toInt(str, 0);
	}

	/**
	 * 指定された文字列を整数へ変換して返します。
	 * 指定された文字列が整数でない場合は、指定された既定値を返します。
	 * 
	 * @param str 文字列
	 * @param defaultValue 既定値
	 * @return 変換された整数。または既定値
	 */
	public static int toInt(final String str, final int defaultValue) {
		if (str == null) {
			return defaultValue;
		}

		try {
			return Integer.parseInt(str);
		} catch (NumberFormatException nfe) {
			return defaultValue;
		}
	}

}
