/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class CompressMethod {
    public static final String LH0 = "-lh0-";
    public static final String LH1 = "-lh1-";
    public static final String LH2 = "-lh2-";
    public static final String LH3 = "-lh3-";
    public static final String LH4 = "-lh4-";
    public static final String LH5 = "-lh5-";
    public static final String LH6 = "-lh6-";
    public static final String LH7 = "-lh7-";
    public static final String LHD = "-lhd-";
    public static final String LZS = "-lzs-";
    public static final String LZ4 = "-lz4-";
    public static final String LZ5 = "-lz5-";

    private CompressMethod() {
    }

    public static int toDictionarySize(String method) {
        if (LZS.equalsIgnoreCase(method)) {
            return 2048;
        }
        if (LZ5.equalsIgnoreCase(method)) {
            return 4096;
        }
        if (LH1.equalsIgnoreCase(method)) {
            return 4096;
        }
        if (LH2.equalsIgnoreCase(method)) {
            return 8192;
        }
        if (LH3.equalsIgnoreCase(method)) {
            return 8192;
        }
        if (LH4.equalsIgnoreCase(method)) {
            return 4096;
        }
        if (LH5.equalsIgnoreCase(method)) {
            return 8192;
        }
        if (LH6.equalsIgnoreCase(method)) {
            return 32768;
        }
        if (LH7.equalsIgnoreCase(method)) {
            return 65536;
        }
        if (LZ4.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (LH0.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (LHD.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        throw new IllegalArgumentException("Unknown compress method. " + method);
    }

    public static int toThreshold(String method) {
        if (LZS.equalsIgnoreCase(method)) {
            return 2;
        }
        if (LZ5.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LH1.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LH2.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LH3.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LH4.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LH5.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LH6.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LH7.equalsIgnoreCase(method)) {
            return 3;
        }
        if (LZ4.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (LH0.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (LHD.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        throw new IllegalArgumentException("Unknown compress method. " + method);
    }

    public static int toMaxMatch(String method) {
        if (LZS.equalsIgnoreCase(method)) {
            return 17;
        }
        if (LZ5.equalsIgnoreCase(method)) {
            return 18;
        }
        if (LH1.equalsIgnoreCase(method)) {
            return 60;
        }
        if (LH2.equalsIgnoreCase(method)) {
            return 256;
        }
        if (LH3.equalsIgnoreCase(method)) {
            return 256;
        }
        if (LH4.equalsIgnoreCase(method)) {
            return 256;
        }
        if (LH5.equalsIgnoreCase(method)) {
            return 256;
        }
        if (LH6.equalsIgnoreCase(method)) {
            return 256;
        }
        if (LH7.equalsIgnoreCase(method)) {
            return 256;
        }
        if (LZ4.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (LH0.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (LHD.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException(String.valueOf(method) + " means no compress.");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        throw new IllegalArgumentException("Unknown compress method. " + method);
    }

    public static OutputStream connectEncoder(OutputStream out, String method, Properties property) {
        String packages;
        String key = "lha." + CompressMethod.getCore(method) + ".encoder";
        String generator = property.getProperty(key);
        if (generator == null) {
            generator = LhaProperty.getProperty(key);
        }
        if ((packages = property.getProperty("lha.packages")) == null) {
            packages = LhaProperty.getProperty("lha.packages");
        }
        Hashtable<String, OutputStream> substitute = new Hashtable<String, OutputStream>();
        substitute.put("out", out);
        return (OutputStream)LhaProperty.parse(generator, substitute, packages);
    }

    public static InputStream connectDecoder(InputStream in, String method, Properties property, long length) {
        String packages;
        String key = "lha." + CompressMethod.getCore(method) + ".decoder";
        String generator = property.getProperty(key);
        if (generator == null) {
            generator = LhaProperty.getProperty(key);
        }
        if ((packages = property.getProperty("lha.packages")) == null) {
            packages = LhaProperty.getProperty("lha.packages");
        }
        Hashtable<String, Object> substitute = new Hashtable<String, Object>();
        substitute.put("in", in);
        substitute.put("length", new Long(length));
        return (InputStream)LhaProperty.parse(generator, substitute, packages);
    }

    private static String getCore(String method) {
        if (method.startsWith("-") && method.endsWith("-")) {
            return method.substring(1, method.lastIndexOf(45)).toLowerCase();
        }
        throw new IllegalArgumentException("");
    }
}

