/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.sf.orangesignal.csv.handlers.BeanOrder;

public class BeanOrderComparator
implements Comparator<Object> {
    private List<BeanOrder> orders;

    protected BeanOrderComparator(List<BeanOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("orders must not be null");
        }
        this.orders = orders;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            throw new IllegalArgumentException("bean must not be null");
        }
        for (BeanOrder order : this.orders) {
            int c = order.compare(o1, o2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public static void sort(List<?> beans, List<BeanOrder> orders) {
        if (beans.size() > 1) {
            Collections.sort(beans, new BeanOrderComparator(orders));
        }
    }
}

