/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;

public class BeanOrder
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 4724322731264848338L;
    private String name;
    private boolean ignoreCase;
    private boolean ascending;

    protected BeanOrder(String name, boolean ignoreCase, boolean ascending) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("propertyName must not be null or empty");
        }
        this.name = name;
        this.ignoreCase = ignoreCase;
        this.ascending = ascending;
    }

    public static BeanOrder asc(String name) {
        return new BeanOrder(name, false, true);
    }

    public static BeanOrder asc(String name, boolean ignoreCase) {
        return new BeanOrder(name, ignoreCase, true);
    }

    public static BeanOrder desc(String name) {
        return new BeanOrder(name, false, false);
    }

    public static BeanOrder desc(String name, boolean ignoreCase) {
        return new BeanOrder(name, ignoreCase, false);
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object v1 = this.getValue(o1);
        Object v2 = this.getValue(o2);
        if (this.ignoreCase && v1 instanceof String && v2 instanceof String) {
            v1 = ((String)v1).toLowerCase();
            v2 = ((String)v2).toLowerCase();
        }
        return this.compareValue(v1, v2) * (this.ascending ? 1 : -1);
    }

    private Object getValue(Object bean) {
        try {
            Field field = bean.getClass().getDeclaredField(this.name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                return field.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot get " + field.getName() + ": " + e.getMessage(), e);
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field " + this.name + " not found in " + bean.getClass().getName() + ": " + e.getMessage(), e);
        }
    }

    private int compareValue(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return ((Comparable)v1).compareTo(v2);
    }

    public String toString() {
        return this.name + ' ' + (this.ascending ? "asc" : "desc");
    }
}

