/*
 * Decompiled with CFR 0.152.
 */
package epayment.processor;

import epayment.framework.IGatewayAdapter;
import epayment.framework.IPaymentCommand;
import epayment.framework.IPaymentResponse;
import epayment.framework.PaymentException;
import epayment.processor.PaymentProcessorConfigurator;

public class PaymentProcessor {
    private IGatewayAdapter _adapter;
    private static PaymentProcessor _processor;

    public PaymentProcessor() {
        try {
            PaymentProcessorConfigurator configurator = new PaymentProcessorConfigurator();
            configurator.configure(this);
        }
        catch (Exception e) {
            System.err.println("Payment processor configuration error: " + e.getMessage());
        }
    }

    public PaymentProcessor(IGatewayAdapter adapter) {
        this.setGatewayAdapter(adapter);
    }

    public static PaymentProcessor getProcessor() {
        if (_processor == null) {
            _processor = new PaymentProcessor();
        }
        return _processor;
    }

    protected void setGatewayAdapter(IGatewayAdapter adapter) {
        this._adapter = adapter;
    }

    public IPaymentResponse process(IPaymentCommand command) throws PaymentException {
        return command.execute(this._adapter);
    }
}

